/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessagePreprocessor;
import com.ur.log.logentry.robotmessage.SafetyModeCategory;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.SafetyMode;
import gui.debug.FlightReportAttachmentService;
import javax.inject.Inject;

public class ErrorReporterMessagePreprocessor
implements RobotMessagePreprocessor {
    private final FlightReportAttachmentService flightReportAttachmentService;
    private SafetyMode currentState;

    @Inject
    public ErrorReporterMessagePreprocessor(FlightReportAttachmentService flightReportAttachmentService) {
        this.flightReportAttachmentService = flightReportAttachmentService;
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        boolean stateChanged;
        boolean bl = stateChanged = this.currentState != robotMessage.safetyMode;
        if (stateChanged && EqualsUtil.equalsOneOf((Object)SafetyModes.getSafetyModeCategory((SafetyMode)robotMessage.safetyMode), (Object[])new SafetyModeCategory[]{SafetyModeCategory.PROTECTIVE_STOP, SafetyModeCategory.VIOLATION, SafetyModeCategory.FAULT, SafetyModeCategory.EMERGENCY_STOP, SafetyModeCategory.BRAKE_FAILURE})) {
            this.flightReportAttachmentService.enrichReport(robotMessage, FlightRecorderTriggerType.CONTROLLER_REPORTED_ERROR);
            Log.info((String)("Flight reporter triggered, safety mode: " + robotMessage.safetyMode));
        }
        this.currentState = robotMessage.safetyMode;
    }
}

