/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.safety.Settings;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.dev.SafetyMode;
import javax.inject.Inject;

public class InformOnSafetyMessageSent
implements RobotMessageListener {
    private final SafetyStopMessageListenerFacade userRequestSafetyMode;

    @Inject
    public InformOnSafetyMessageSent(SafetyStopMessageListenerFacade userRequest) {
        this.userRequestSafetyMode = userRequest;
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        if (robotMessage.type == RobotMessageType.SAFETY_MODE) {
            switch (SafetyModes.getSafetyModeCategory((SafetyMode)robotMessage.safetyMode)) {
                case NORMAL: 
                case REDUCED: 
                case SAFEGUARD_STOP: 
                case THREE_POSITION_ENABLING_STOP: 
                case WAITING_FOR_PARAMETERS: {
                    break;
                }
                case PROTECTIVE_STOP: {
                    this.userRequestSafetyMode.informUserOfProtectiveStop(robotMessage);
                    break;
                }
                case RECOVERY: 
                case EMERGENCY_STOP: 
                case VIOLATION: 
                case FAULT: 
                case VALIDATE_JOINT_ID: {
                    this.userRequestSafetyMode.informUserOfErrorState(robotMessage);
                    break;
                }
                default: {
                    if (!Settings.isRunningInDevelopmentMode()) break;
                    throw new IllegalStateException("Unexpected safety mode given " + robotMessage.safetyMode.name());
                }
            }
        }
    }

    public static interface SafetyStopMessageListenerFacade {
        public void informUserOfErrorState(RobotMessage var1);

        public void informUserOfProtectiveStop(RobotMessage var1);
    }
}

