/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.safety.ControllerSocketSender;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetySetupPanesRenderer;
import com.ur.safety.SafetySetupToHtmlRenderer;
import com.ur.safety.SafetyTextResource;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.InformationMessage;
import com.ur.swing.dialog.MultiPaneMessagePanelFactory;
import com.ur.swing.dialog.OkCancelDialogListener;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.Optional;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.view.constants.runtime.PolyscopeFaultType;
import gui.installation.RobotInstallationLookupService;
import gui.tools.DialogCreator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class MonitorSafetySetupApplicationWorkflow
extends SafetyChangeListener.Template {
    static final int TIME_TO_WAIT_FOR_RESPONSE_FROM_CONTROLLER = 10000;
    private final MultiPaneMessagePanelFactory multiPaneMessagePanelFactory;
    private final TaskMonitor taskMonitor;
    private final SafetySetupPanesRenderer renderer;
    private final SafetySettingsLookupService safetyLookupService;
    private final RobotInstallationLookupService robotInstallationService;
    private final DialogCreator dialogCreator;
    private final SafetyTextResource textResource;
    private SafetySetup oldSetup;
    private SafetySetup lastConfirmedSafety;
    private boolean safetyToApplyIsVerified;
    ProgressBarHandler progressBarHandler;
    private final RobotInstallationPersistenceService persistenceService;

    @Inject
    MonitorSafetySetupApplicationWorkflow(TaskMonitor taskMonitor, SafetySetupPanesRenderer renderer, SafetySettingsLookupService safetyLookupService, RobotInstallationLookupService robotInstallationService, MultiPaneMessagePanelFactory multiPaneMessagePanelFactory, EventManager eventManager, DialogCreator dialogCreator, SafetyTextResource textResource, RobotInstallationPersistenceService persistenceService) {
        this.taskMonitor = taskMonitor;
        this.renderer = renderer;
        this.safetyLookupService = safetyLookupService;
        this.robotInstallationService = robotInstallationService;
        this.multiPaneMessagePanelFactory = multiPaneMessagePanelFactory;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        this.persistenceService = persistenceService;
        renderer.setDisplayUnits(SafetySetupToHtmlRenderer.DisplayUnits.UNCONVERTED);
        this.progressBarHandler = new ProgressBarHandler(10000, eventManager);
    }

    @Override
    public void safetyRequestedToBeApplied(SafetySetup setup) {
        boolean sameAsActive;
        Log.trace((String)("is setup verified -> " + this.safetyToApplyIsVerified));
        this.safetyToApplyIsVerified = ((VersionComponent)setup.getComponent(VersionComponent.class)).isVerified();
        Optional<SafetySetup> controllerSafetySetup = this.safetyLookupService.getControllerSafetySetup();
        this.oldSetup = controllerSafetySetup.isPresent() ? ((sameAsActive = this.safetyLookupService.isSameAsActive(setup)) ? null : (SafetySetup)controllerSafetySetup.get()) : null;
        this.progressBarHandler.startProgressMonitor();
    }

    @Override
    public void safetyOnControllerUpdated(SafetySetup setup, SafetySetup previousSetup) {
        if (this.isRevertedSafety(setup, previousSetup)) {
            return;
        }
        if (!this.safetyToApplyIsVerified && !((VersionComponent)setup.getComponent(VersionComponent.class)).isVerified()) {
            this.showConfirmSafetyDialog(setup);
            return;
        }
        this.sendConfirmationOfSafetySetup(setup);
    }

    private boolean isRevertedSafety(SafetySetup setup, SafetySetup previousSetup) {
        boolean isReverted = this.isSafetySetupARevert(setup, previousSetup);
        if (isReverted) {
            this.handleRevertedSafety(setup, previousSetup);
            return true;
        }
        return false;
    }

    private boolean isSafetySetupARevert(SafetySetup newSetup, SafetySetup previousSetup) {
        boolean hasPreviousSetup = previousSetup != null;
        boolean previousSetupAndUpdatedSafetyIsNotTheSame = EqualsUtil.notEquals((Object)newSetup, (Object)previousSetup);
        boolean hasAConfirmedSafety = this.lastConfirmedSafety != null;
        boolean confirmedSafetyAndUpdatedSafetyIsTheSame = EqualsUtil.equals((Object)this.lastConfirmedSafety, (Object)newSetup);
        return hasPreviousSetup && previousSetupAndUpdatedSafetyIsNotTheSame && hasAConfirmedSafety && confirmedSafetyAndUpdatedSafetyIsTheSame;
    }

    private void handleRevertedSafety(SafetySetup setup, SafetySetup previousSetup) {
        this.sendRevertSafety(setup, previousSetup);
        this.sendConfirmationOfSafetySetup(setup);
    }

    private void sendRevertSafety(SafetySetup setup, SafetySetup revertedSetup) {
        EventNotificationService.notify(SafetyChangeListener.class, listener -> listener.safetyReverted(revertedSetup, setup));
    }

    @Override
    public void safetyMismatchWithController() {
        Log.trace((String)"sending fault to controller");
        this.sendSafetyMismatchFault();
    }

    private ConfirmationMessage confirmChangesToTheSettings() {
        return new ConfirmationMessage(DialogWithName.CONFIRM_SAFETY_CONFIGURATION.getName(), this.textResource.confirmChangesToTheSettingsTitle(), "", this.textResource.confirmChangesToTheSettingsAction(), this.textResource.confirmChangesToTheSettingsCancel());
    }

    void showConfirmSafetySetupOnController(SafetySetup setup, OkCancelDialogListener okCancelDialogListener) {
        try {
            ConfirmationMessage message = this.confirmChangesToTheSettings();
            message.setId(setup.hashCode());
            message.setSuppressKey("suppressDialogConfirmSafety");
            Iterable<MultiPaneMessagePanelFactory.Pane> panes = this.renderer.generateMultiPaneMessage(setup);
            if (this.oldSetup == null) {
                this.dialogCreator.showMultiPaneInformationDialog(this.multiPaneMessagePanelFactory, (InformationMessage)message, panes, okCancelDialogListener);
            } else {
                this.dialogCreator.showMultiPaneConfirmationDialog(this.multiPaneMessagePanelFactory, message, panes, okCancelDialogListener);
            }
        }
        catch (Exception e) {
            Log.error((String)"Failed to generate confirmation dialog", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void sendConfirmationOfSafetySetup(SafetySetup setup) {
        ControllerSocketSender.sendConfirmtionOfSafetySetup();
        if (setup != null) {
            ((VersionComponent)setup.getComponent(VersionComponent.class)).setVerified(true);
        }
        this.lastConfirmedSafety = setup;
        EventNotificationService.notify(SafetyChangeListener.class, listener -> listener.safetyOnControllerConfirmed(setup));
        this.safetyToApplyIsVerified = false;
    }

    private void sendSafetyMismatchFault() {
        ControllerSocketSender.sendPolyScopeFault(PolyscopeFaultType.SAFETY_MISMATCH);
    }

    void performSaveOfInstallation() {
        this.persistenceService.save(this.robotInstallationService.getInstallation());
    }

    private void showConfirmSafetyDialog(SafetySetup safetySetupToConfirm) {
        Log.trace((String)"executing confirmation dialog");
        OkCancelDialogListener okCancelDialogListener = this.createOkCancelListener(safetySetupToConfirm);
        SwingUtil.invokeAndWait(() -> this.showConfirmSafetySetupOnController(safetySetupToConfirm, okCancelDialogListener));
    }

    private OkCancelDialogListener createOkCancelListener(final SafetySetup safetySetupToConfirm) {
        return new OkCancelDialogListener(){

            public void onOkClicked() {
                Log.trace((String)"approved");
                this.setVerification(true);
                MonitorSafetySetupApplicationWorkflow.this.sendConfirmationOfSafetySetup(safetySetupToConfirm);
                MonitorSafetySetupApplicationWorkflow.this.performSaveOfInstallation();
            }

            public void onCancelClicked() {
                Log.trace((String)"declined");
                this.setVerification(false);
                MonitorSafetySetupApplicationWorkflow.this.safetyLookupService.getCaretaker().resetControllerWithSafetySetup(MonitorSafetySetupApplicationWorkflow.this.oldSetup);
            }

            public void onRejected() {
                Log.trace((String)"rejected");
            }

            private void setVerification(boolean verification) {
                MonitorSafetySetupApplicationWorkflow.this.safetyLookupService.getSafetyComponent(VersionComponent.class).setVerified(verification);
            }
        };
    }

    class ProgressBarHandler
    extends SafetyChangeListener.Template {
        private Future applySafetyTask;
        private Timer timer = new Timer(true);
        private final int timeOutInMilliSeconds;
        private final EventManager eventManager;
        private Subscription subscription = Subscription.NULL;
        private final AtomicBoolean isMonitoring = new AtomicBoolean();

        ProgressBarHandler(int timeOutInMilliSeconds, EventManager eventManager) {
            this.timeOutInMilliSeconds = timeOutInMilliSeconds;
            this.eventManager = eventManager;
            this.isMonitoring.set(false);
        }

        @Override
        public void safetyOnControllerUpdated(SafetySetup setup, SafetySetup previousSafety) {
            SwingUtil.invokeLater(this::stopProgressMonitor);
        }

        @Override
        public void safetyMismatchWithController() {
            SwingUtil.invokeLater(this::stopProgressMonitor);
        }

        synchronized void startProgressMonitor() {
            if (this.isMonitoring.compareAndSet(false, true)) {
                this.subscription = this.eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
                this.applySafetyTask = MonitorSafetySetupApplicationWorkflow.this.taskMonitor.start(this.getApplySafetyText());
                this.startTimerOutTimerTask();
            }
        }

        private String getApplySafetyText() {
            return MonitorSafetySetupApplicationWorkflow.this.textResource.applyingSafetySettingsToController();
        }

        synchronized void stopProgressMonitor() {
            if (this.isMonitoring.compareAndSet(true, false)) {
                Log.trace((String)"Closing progressbar dialog");
                this.subscription.dispose();
                this.timer.cancel();
                MonitorSafetySetupApplicationWorkflow.this.taskMonitor.stop(this.applySafetyTask);
            }
        }

        void startTimerOutTimerTask() {
            this.timer.cancel();
            this.timer = new Timer(true);
            this.timer.schedule(this.createTimerTask(), this.timeOutInMilliSeconds);
        }

        private TimerTask createTimerTask() {
            return new TimerTask(){

                @Override
                public void run() {
                    ProgressBarHandler.this.stopProgressMonitor();
                }
            };
        }
    }
}

