/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.util.event.EventNotificationService;
import javax.inject.Inject;

public class PowerOffOnEditSafetyLockListener
implements SafetyLockListener {
    private ControllerInterface controllerInterface;

    @Inject
    private PowerOffOnEditSafetyLockListener(SafetyLock safetyLock, ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
        safetyLock.addSafetyLockListener(this);
    }

    @Override
    public void doUnlock() {
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(PowerOffOnEditSafetyLockListener.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        RobotState rs = RobotState.getLatestRobotState();
        switch (rs.robotMode) {
            case NO_CONTROLLER: 
            case DISCONNECTED: 
            case CONFIRM_SAFETY: 
            case BOOTING: 
            case POWER_OFF: {
                break;
            }
            default: {
                this.controllerInterface.runScript("power off");
            }
        }
    }

    @Override
    public void doLock() {
        EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(PowerOffOnEditSafetyLockListener.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
    }
}

