/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.requirements.PlayProgramRequirement;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.monitor.model.SafetyMasterboard;
import com.ur.view.constants.dev.SafetyMode;
import javax.inject.Inject;
import javax.inject.Provider;

public class SafeGuardStopRequirement
implements PlayProgramRequirement {
    private final Provider<SafetyMasterboard> masterBoardProvider;
    private SafetySettingsLookupService lookupService;

    @Inject
    SafeGuardStopRequirement(SafetySettingsLookupService lookupService, @Source(value=SafetyMasterboard.class) Recipe<SafetyMasterboard> masterBoardRecipe) {
        this.lookupService = lookupService;
        this.masterBoardProvider = masterBoardRecipe.lastProvider();
    }

    public boolean check() {
        SafetyMasterboard state = (SafetyMasterboard)this.masterBoardProvider.get();
        SafetyIOConfiguration safetyIO = this.lookupService.getSafetyComponent(SafetyIOConfiguration.class);
        boolean normalOrReducedSafety = state.isNormalOrReducedMode();
        boolean safeguardStopped = state.isSafeguardStopped();
        boolean resetConfigured = safetyIO.getSafeguardStopResetInputs().isAssigned();
        return normalOrReducedSafety || safeguardStopped && resetConfigured || state.getSafetyMode() == SafetyMode.TP_THREE_POSITION_ENABLING_STOP;
    }
}

