/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.monitor.InformOnSafetyMessageSent;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import gui.main.MainView;
import gui.polyscope.setup.RobotPositionVerificationPanel;
import gui.tools.DialogCreator;
import javax.inject.Inject;

public final class SafetyStopMessageListenerFacadeImplementation
extends SafetyChangeListener.Template
implements InformOnSafetyMessageSent.SafetyStopMessageListenerFacade {
    private final MainView mainPanel;
    private final RobotPositionVerificationPanel positionVerificationPanel;
    private final RobotInitializationService initializationRobotDialog;
    private final EventManager eventManager;
    private final DialogCreator dialogCreator;
    private boolean isSafetyBeingApplied = false;

    @Inject
    public SafetyStopMessageListenerFacadeImplementation(MainView mainPanel, RobotPositionVerificationPanel positionVerificationPanel, RobotInitializationService initializationRobotDialog, EventManager eventManager, DialogCreator dialogCreator) {
        this.mainPanel = mainPanel;
        this.positionVerificationPanel = positionVerificationPanel;
        this.initializationRobotDialog = initializationRobotDialog;
        this.eventManager = eventManager;
        this.dialogCreator = dialogCreator;
        eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
    }

    @Override
    public void informUserOfErrorState(RobotMessage message) {
        if (this.isSafetyBeingApplied) {
            new ShowRobotMessageAfterConfirmedSafetyConfirmed(message);
        } else {
            this.showRobotMessage(message);
        }
    }

    @Override
    public void informUserOfProtectiveStop(final RobotMessage message) {
        if (message.errorCode == ErrorCode.ROBOT_RESTARTED_AFTER_JOINT_POSITION_DISAGREEMENT || message.errorCode == ErrorCode.ROBOT_MOVED_WHILE_UNPOWERED) {
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SafetyStopMessageListenerFacadeImplementation.this.positionVerificationPanel.setProtectiveStopText(message);
                    SafetyStopMessageListenerFacadeImplementation.this.mainPanel.getSwitchSupport().stackCurrentCardAndSwitchTo(RobotPositionVerificationPanel.class);
                }
            });
        } else {
            this.showRobotMessage(message);
        }
    }

    @Override
    public void safetyRequestedToBeApplied(SafetySetup setup) {
        this.isSafetyBeingApplied = true;
    }

    @Override
    public void safetyOnControllerConfirmed(SafetySetup setup) {
        this.isSafetyBeingApplied = false;
    }

    private void showRobotMessage(final RobotMessage message) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SafetyStopMessageListenerFacadeImplementation.this.dialogCreator.popupSafetyModeDialog(message, SafetyStopMessageListenerFacadeImplementation.this.initializationRobotDialog);
            }
        }, "Invoke-SafetyViolation-Dialog");
        thread.start();
    }

    private class ShowRobotMessageAfterConfirmedSafetyConfirmed
    extends SafetyChangeListener.Template {
        private final Subscription subscription;
        private final RobotMessage robotMessage;

        ShowRobotMessageAfterConfirmedSafetyConfirmed(RobotMessage robotMessage) {
            this.robotMessage = robotMessage;
            this.subscription = SafetyStopMessageListenerFacadeImplementation.this.eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
        }

        @Override
        public void safetyOnControllerConfirmed(SafetySetup setup) {
            SafetyStopMessageListenerFacadeImplementation.this.showRobotMessage(this.robotMessage);
            this.subscription.dispose();
        }
    }
}

