/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.monitor;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.program.ProgramLoadingContext;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.checksum.CRCCheck;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.stream.InternalData;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ValidateChecksumFromController
extends SafetyChangeListener.Template
implements PropertyChangeListener {
    public static final int THRESHOLD_OF_BAD_CRC_CHECKS = 3;
    private final Provider<InternalData> internalDataProvider;
    private SafetySettingsLookupService safetyLookupService;
    private final ProgramLoadingContext programLoadingContext;
    private RobotInstallationSite robotInstallationSite;
    private Recipe<CRCCheck> crcCheckRecipe;
    private int badCRCCounter = 0;
    private Subscription subscription = Subscription.NULL;

    @Inject
    ValidateChecksumFromController(SafetySettingsLookupService safetyLookupService, ProgramLoadingContext programLoadingContext, RobotInstallationSite robotInstallationSite, @Source(value=InternalData.class) Recipe<InternalData> internalDataRecipe, @Source(value=CRCCheck.class) Recipe<CRCCheck> crcCheckRecipe) {
        this.safetyLookupService = safetyLookupService;
        this.programLoadingContext = programLoadingContext;
        this.robotInstallationSite = robotInstallationSite;
        this.crcCheckRecipe = crcCheckRecipe;
        this.internalDataProvider = internalDataRecipe.lastProvider();
        if (safetyLookupService.getSafetySetup() != null) {
            this.safetyLoaded(safetyLookupService.getSafetySetup());
        }
    }

    private void crcUpdate(CRCCheck crcCheckFromSCB) {
        if (this.hasNotConfirmedSafety()) {
            return;
        }
        if (this.loadingInProgress()) {
            return;
        }
        SafetySetup safetySetup = this.safetyLookupService.getSafetySetup();
        String generatedChecksum = this.safetyLookupService.generateChecksum(safetySetup);
        int n = this.badCRCCounter = crcCheckFromSCB.equalTo(generatedChecksum) ? 0 : this.badCRCCounter + 1;
        if (this.badCRCCounter > 3) {
            this.sendSafetyMismatchFault();
            Log.error((String)("Received " + crcCheckFromSCB + " from controller, but expected " + generatedChecksum + ". Safety version " + this.safetyLookupService.getSafetyComponent(VersionComponent.class).getChecksumVersion()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.safetyLookupService.getSafetyComponent(VersionComponent.class).setVerified(false);
        this.unsubscribeToCRCCheckStream();
    }

    @Override
    public void safetyRequestedToBeApplied(SafetySetup setup) {
        this.unsubscribeToCRCCheckStream();
    }

    @Override
    public void safetyOnControllerUpdated(SafetySetup setup, SafetySetup previousSafety) {
        this.badCRCCounter = 0;
        this.subscribeToCRCCheckStream();
    }

    @Override
    public void safetyLoaded(SafetySetup setup) {
        this.unsubscribeToCRCCheckStream();
        setup.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private boolean hasNotConfirmedSafety() {
        switch (((InternalData)this.internalDataProvider.get()).getRobotModeWithNewStates()) {
            case NO_CONTROLLER: 
            case DISCONNECTED: 
            case CONFIRM_SAFETY: 
            case BOOTING: 
            case UPDATING: {
                return true;
            }
        }
        return false;
    }

    private boolean loadingInProgress() {
        return this.programLoadingContext.isLoading() || this.robotInstallationSite.isLoadingInstallation();
    }

    private void subscribeToCRCCheckStream() {
        if (this.subscription == Subscription.NULL) {
            this.subscription = this.crcCheckRecipe.executeOnIOThread().subscribe(this::crcUpdate);
        }
    }

    private void unsubscribeToCRCCheckStream() {
        this.subscription.dispose();
        this.subscription = Subscription.NULL;
    }

    void sendSafetyMismatchFault() {
        EventNotificationService.notify(SafetyChangeListener.class, SafetyChangeListener::safetyMismatchWithController);
    }
}

