/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.profisafe;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.profinet.daemon.ProfinetDaemonState;
import com.ur.polyscope.profinet.installation.ProfinetService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.profisafe.ProfinetMonitorCallback;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.util.concurrent.SequentialTask;
import com.ur.util.logging.Log;
import gui.tools.DialogCreator;
import javax.inject.Inject;

public class ProfinetTask
extends SequentialTask {
    private static final int STARTING_TIMEOUT = 5000;
    private static final int ERROR_TIMEOUT = 500;
    private final ProfinetService profinetService;
    private final DialogCreator dialogCreator;
    private final ProfinetMonitorCallback callback;
    private final SafetyTextResource textResource;

    @Inject
    public ProfinetTask(ProfinetService profinetService, DialogCreator dialogCreator, ProfinetMonitorCallback callback, SafetyTextResource textResource) {
        super(textResource.profisafeTaskCaption(), false);
        this.profinetService = profinetService;
        this.dialogCreator = dialogCreator;
        this.callback = callback;
        this.textResource = textResource;
    }

    public void run() {
        this.profinetService.enableProfinetService();
        long startTime = System.currentTimeMillis();
        while (true) {
            ProfinetDaemonState state;
            if (this.hasState(state = this.profinetService.getProfinetDaemonState(), ProfinetDaemonState.RUNNING, ProfinetDaemonState.CONNECTING)) {
                this.daemonStartedWithSuccess();
                break;
            }
            if (this.isTimeOverdue(startTime, 500L) && this.hasState(state, ProfinetDaemonState.ERROR)) {
                this.daemonDidNotStart();
                break;
            }
            if (this.isTimeOverdue(startTime, 5000L) && this.hasState(state, ProfinetDaemonState.STARTING)) {
                this.daemonDidNotStart();
                break;
            }
            this.sleep(200L);
        }
    }

    private boolean hasState(ProfinetDaemonState actualState, ProfinetDaemonState ... lookupStates) {
        return EqualsUtil.equalsOneOf((Object)actualState, (Object[])lookupStates);
    }

    private void daemonStartedWithSuccess() {
        this.callback.onProfinetDaemonSuccess();
    }

    private void daemonDidNotStart() {
        this.dialogCreator.showMessageDialog((DialogMessage)new PROFInetCouldNotStartDiaglogMessage(this.textResource), MessageDialogType.ERROR, (OkDialogListener)new PROFInetCouldNotStartOkDialogListener(this.callback));
    }

    private boolean isTimeOverdue(long startTime, long errorTimeout) {
        long currentTime = System.currentTimeMillis();
        return currentTime - startTime > errorTimeout;
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Log.warning((String)"Interrupted while sleeping", (Throwable)e);
        }
    }

    private static class PROFInetCouldNotStartDiaglogMessage
    extends DialogMessage {
        public PROFInetCouldNotStartDiaglogMessage(SafetyTextResource textResource) {
            super(textResource.profisafeTaskCouldNotStartCaption(), textResource.profisafeTaskCouldNotStartDescription());
        }
    }

    private static class PROFInetCouldNotStartOkDialogListener
    extends OkDialogListener {
        private final ProfinetMonitorCallback callback;

        public PROFInetCouldNotStartOkDialogListener(ProfinetMonitorCallback callback) {
            this.callback = callback;
        }

        public void onOkClicked() {
            this.callback.onProfinetDaemonError();
        }
    }
}

