/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.profisafe;

import com.ur.lang.EndianConverter;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyEndianConverter;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.safety.profisafe.ProfisafeConfiguration;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class ProfisafeConfigurationParser
extends SafetyConfigurationParser.ActiveParserTemplate<ProfisafeConfiguration> {
    private ProfisafeConfiguration result;
    private EndianConverter endianConverter;

    @Inject
    public ProfisafeConfigurationParser(SafetyEndianConverter safetyEndianConverter) {
        this.endianConverter = safetyEndianConverter.getConverter();
    }

    @Override
    public void parse(DataInput input, ChecksumVersion version) throws IOException {
        if (version.atLeast(ChecksumVersion.VERSION_5_6)) {
            this.result = new ProfisafeConfiguration();
            this.result.setEnabled(input.readBoolean());
            this.result.setSourceAddress(this.endianConverter.getUnsignedShort(input));
            this.result.setDestinationAddress(this.endianConverter.getUnsignedShort(input));
            this.result.setOperationalModeEnabled(input.readBoolean());
        }
    }

    @Override
    public Class<ProfisafeConfiguration> getType() {
        return ProfisafeConfiguration.class;
    }

    @Override
    public ProfisafeConfiguration getResult() {
        return this.result;
    }
}

