/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.profisafe;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.profisafe.ProfisafeConfiguration;

public class ProfisafeContribution
implements SafetySetupContribution<ProfisafeConfiguration> {
    private static final String PROFISAFE_SECTION_NAME = "Profisafe";

    public Class<ProfisafeConfiguration> getComponentType() {
        return ProfisafeConfiguration.class;
    }

    public ProfisafeConfiguration createDefaultComponent() {
        return new ProfisafeConfiguration();
    }

    public ProfisafeConfiguration readFromOptions(ChecksumVersion version, Options options) {
        ProfisafeConfiguration configuration = this.createDefaultComponent();
        OptionsSection section = options.getSection(PROFISAFE_SECTION_NAME);
        configuration.setEnabled(section.getInteger("profisafeEnabled", Integer.valueOf(0)) != 0);
        configuration.setSourceAddress(section.getInteger("profisafeSourceAddress", Integer.valueOf(0)));
        configuration.setDestinationAddress(section.getInteger("profisafeDestinationAddress", Integer.valueOf(0)));
        configuration.setOperationalModeEnabled(section.getInteger("profisafeOperationalMode", Integer.valueOf(0)) != 0);
        return configuration;
    }

    public void copyToOptions(ChecksumVersion version, Options options, ProfisafeConfiguration component) {
        this.copyTo(options, component);
    }

    public void copyControllerRepresentationTo(ChecksumVersion version, Options options, ProfisafeConfiguration component) {
        this.copyTo(options, component);
    }

    private void copyTo(Options options, ProfisafeConfiguration component) {
        OptionsSection section = options.getSection(PROFISAFE_SECTION_NAME);
        section.setInteger("profisafeEnabled", Integer.valueOf(component.isEnabled() ? 1 : 0));
        section.setInteger("profisafeSourceAddress", Integer.valueOf(component.getSourceAddress()));
        section.setInteger("profisafeDestinationAddress", Integer.valueOf(component.getDestinationAddress()));
        section.setInteger("profisafeOperationalMode", Integer.valueOf(component.isOperationalModeEnabled() ? 1 : 0));
    }

    public boolean isSupported(ChecksumVersion version) {
        return version.atLeast(ChecksumVersion.VERSION_5_6);
    }
}

