/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.profisafe;

import com.google.inject.Inject;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.domain.SetInstallationValidator;
import com.ur.polyscope.license.LicenseManager;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.profisafe.ProfisafeConfiguration;
import com.ur.swing.dialog.ErrorMessage;
import gui.main.URGUI;

public class ProfisafeInstallationValidator
implements SetInstallationValidator {
    public static final String PROFISAFE_FEATURE_NAME = "profisafe";
    private static final String DEFAULT_INSTALLATION_BACKUP_FILE_NAME = "default.installation.problem";
    private final SafetyTextResource safetyTextResource;
    private final LicenseManager licenseManager;

    @Inject
    public ProfisafeInstallationValidator(SafetyTextResource safetyTextResource, LicenseManager licenseManager) {
        this.safetyTextResource = safetyTextResource;
        this.licenseManager = licenseManager;
    }

    public SetInstallationValidator.Validity validate(Installation toValidate) {
        SafetySetup safetySetup = (SafetySetup)toValidate.getComponent(SafetySetup.class);
        ProfisafeConfiguration profisafeConfiguration = (ProfisafeConfiguration)safetySetup.getComponent(ProfisafeConfiguration.class);
        if (profisafeConfiguration.isEnabled() && !this.licenseManager.isFeatureActive(PROFISAFE_FEATURE_NAME)) {
            return SetInstallationValidator.Validity.ERROR;
        }
        return SetInstallationValidator.Validity.VALID;
    }

    public ErrorMessage getErrorMessage(Installation toValidate) {
        if (!URGUI.isInitialized() && EqualsUtil.equals((Object)((PersistanceMetaData)toValidate.getMetaData(PersistanceMetaData.class)).fileName(), (Object)"default")) {
            return this.getErrorMessageInDefaultInstallationOnPolyscopeStartup();
        }
        return this.getErrorMessageOnInstallationLoaded();
    }

    private ErrorMessage getErrorMessageOnInstallationLoaded() {
        return new ErrorMessage(this.safetyTextResource.profisafeNoValidLicenseTitle(), this.safetyTextResource.profisafeNoValidLicenseExplenation());
    }

    private ErrorMessage getErrorMessageInDefaultInstallationOnPolyscopeStartup() {
        return new ErrorMessage(this.safetyTextResource.profisafeNoValidLicenseTitle(), this.safetyTextResource.profisafeInDefaultInstallationNoValidLicenseExplenation("default", DEFAULT_INSTALLATION_BACKUP_FILE_NAME));
    }
}

