/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.profisafe;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.license.LicenseManager;
import com.ur.polyscope.profinet.daemon.ProfinetDaemonState;
import com.ur.polyscope.profinet.installation.ProfinetService;
import com.ur.polyscope.profinet.installation.ProfinetUIState;
import com.ur.polyscope.viewfacade.installation.ProfinetNotDisabledTooltip;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOInputFunction;
import com.ur.safety.profisafe.ProfinetMonitorCallback;
import com.ur.safety.profisafe.ProfinetTaskMonitor;
import com.ur.safety.profisafe.ProfisafeConfiguration;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.OnOffSwitch;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

@Singleton
public class ProfisafePanel
extends ActivatablePanel
implements ReloadOnSafetyLoaded,
SafetyLockListener,
ProfinetMonitorCallback {
    public static final String PROFISAFE_ENABLED = "enabled.profisafePanel";
    public static final String PROFISAFE_SOURCE_ADDRESS = "source.profisafePanel";
    public static final String PROFISAFE_DESTINATION_ADDRESS = "destination.profisafePanel";
    public static final String PROFISAFE_OPERATIONAL_MODE = "operationalmode.profisafePanel";
    private static final int MAX_ADDRESS = 65535;
    private final ViewContext viewContext;
    private final SafetySettingsLookupService safetySettingsLookupService;
    private final SafetyTextResource safetyTextResource;
    private final Provider<ProfinetTaskMonitor> startProfinetAndMonitorProvider;
    private final ProfinetNotDisabledTooltip profinetNotDisabledTooltip;
    private final ProfinetService profinetService;
    protected OnOffSwitch profisafeEnabledSwitch;
    protected NumberField profisafeSourceAddressField;
    protected NumberField profisafeDestinationAddressField;
    protected OnOffSwitch profisafeOperationalModeSwitch;
    private JPanel enabledPanel;
    private JLabel settingsIconLabel;
    protected JPanel settingsPanel;
    private JPanel settingsLabelPanel;
    private JPanel warningPanel;
    private JLabel sourceLabel;
    private JLabel destinationLabel;
    private JLabel operationalModeLabel;
    private JLabel operationalModeMessage;
    private JLabel licenseWarningMessage;
    private final LicenseManager licenseManager;
    private ProfinetTaskMonitor profinetTaskMonitor;

    @Inject
    public ProfisafePanel(SafetyLock safetyLock, SafetySettingsLookupService safetySettingsLookupService, ViewContext viewContext, LicenseManager licenseManager, SafetyTextResource safetyTextResource, Provider<ProfinetTaskMonitor> startProfinetAndMonitorProvider, ProfinetNotDisabledTooltip profinetNotDisabledTooltip, ProfinetService profinetService) {
        this.safetySettingsLookupService = safetySettingsLookupService;
        this.viewContext = viewContext;
        this.licenseManager = licenseManager;
        this.safetyTextResource = safetyTextResource;
        this.startProfinetAndMonitorProvider = startProfinetAndMonitorProvider;
        this.profinetNotDisabledTooltip = profinetNotDisabledTooltip;
        this.profinetService = profinetService;
        this.initComponents();
        safetyLock.addSafetyLockListener(this);
    }

    private void initComponents() {
        this.initEnabledField();
        this.initSourceAddressField();
        this.initDestinationAddressField();
        this.initOperationalModeField();
        this.initOperationalModeWarning();
        this.initLicensWarning();
        this.initLabels();
        this.initPanels();
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setBorder(new CompoundBorder(this.getBorder(), (Border)new CardBorder(this.safetyTextResource.profisafe())));
        this.buildAndUpdateLayout();
    }

    private void buildAndUpdateLayout() {
        this.removeAll();
        this.add(this.enabledPanel);
        this.add(this.settingsLabelPanel);
        if (this.profisafeEnabledSwitch.isSelected()) {
            this.add(this.settingsPanel);
            this.settingsIconLabel.setIcon(ViewImageResource.menuExpandBlack());
        } else {
            this.settingsIconLabel.setIcon(ViewImageResource.menuCollapseBlack());
        }
        this.add(this.warningPanel);
        this.add(Box.createRigidArea(new Dimension(1, 500)));
        this.repaint();
        this.revalidate();
    }

    private void initLicensWarning() {
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.licenseWarningMessage = wf.createLabel(ViewImageResource.formWarning());
        this.licenseWarningMessage.setText(HTML.html((String)this.safetyTextResource.profisafeLicenseWarning()));
    }

    private void initLabels() {
        this.settingsIconLabel = new JLabel(ViewImageResource.menuCollapseBlack());
        this.sourceLabel = new JLabel(this.safetyTextResource.profisafeSourceAddress());
        this.destinationLabel = new JLabel(this.safetyTextResource.profisafeDestinationAddress());
        this.operationalModeLabel = new JLabel(this.safetyTextResource.profisafeOperationalMode());
    }

    private void initPanels() {
        this.enabledPanel = this.viewContext.createFormBuilder().component((JComponent)this.profisafeEnabledSwitch, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW}).getPanel();
        this.enabledPanel.setBorder(new EmptyBorder(10, 10, 5, 10));
        this.settingsLabelPanel = this.viewContext.createFormBuilder().component((JComponent)new JLabel(this.safetyTextResource.configuration()), new FormBuilder.PanelConstraints[0]).spacer(5).component((JComponent)this.settingsIconLabel, new FormBuilder.PanelConstraints[0]).getPanel();
        this.settingsLabelPanel.setBorder(new CompoundBorder(new LineBorder(Color.WHITE, 5), new EmptyBorder(0, 5, 0, 5)));
        this.settingsLabelPanel.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.settingsPanel = this.viewContext.createFormBuilder().component((JComponent)this.sourceLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.profisafeSourceAddressField, new FormBuilder.PanelConstraints[0]).spacer(3).end().component((JComponent)this.destinationLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.profisafeDestinationAddressField, new FormBuilder.PanelConstraints[0]).spacer(3).end().component((JComponent)this.operationalModeLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.profisafeOperationalModeSwitch, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW}).spacer(3).end().component((JComponent)this.operationalModeMessage, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).getPanel();
        this.settingsPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.warningPanel = this.viewContext.createFormBuilder().component((JComponent)this.licenseWarningMessage, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
        this.warningPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
    }

    private void initOperationalModeWarning() {
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.operationalModeMessage = wf.createLabel(ViewImageResource.formWarning());
        this.operationalModeMessage.setText(HTML.html((String)this.safetyTextResource.profisafeOperationalModeWarning()));
    }

    private void initOperationalModeField() {
        this.profisafeOperationalModeSwitch = new OnOffSwitch();
        this.profisafeOperationalModeSwitch.setEnabled(false);
        this.profisafeOperationalModeSwitch.setName(PROFISAFE_OPERATIONAL_MODE);
        this.profisafeOperationalModeSwitch.addActionListener(e -> {
            this.getProfisafeConfiguration().setOperationalModeEnabled(this.profisafeOperationalModeSwitch.isSelected());
            boolean isIOOperationalModelAssigned = this.getSafetyIOConfiguration().getOperationalModeInputs().isAssigned();
            if (this.profisafeOperationalModeSwitch.isSelected() && isIOOperationalModelAssigned) {
                this.getSafetyIOConfiguration().setInput(this.getSafetyIOConfiguration().getOperationalModeInputs(), SafetyIOInputFunction.UNASSIGNED);
                this.update();
            }
        });
    }

    private void initDestinationAddressField() {
        String errorMessage = this.safetyTextResource.valueOutOfRange(0.0, "", 65535.0);
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.profisafeDestinationAddressField = wf.createNumberField(e -> this.getProfisafeConfiguration().setDestinationAddress(((Double)this.profisafeDestinationAddressField.getValue()).intValue()));
        this.profisafeDestinationAddressField.setEnabled(false);
        this.profisafeDestinationAddressField.setName(PROFISAFE_DESTINATION_ADDRESS);
        this.profisafeDestinationAddressField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"######"));
        this.profisafeDestinationAddressField.setMode(Mode.PositiveWholeNumbers);
        this.profisafeDestinationAddressField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)65535.0, (boolean)true, (String)errorMessage)});
    }

    private void initSourceAddressField() {
        String errorMessage = this.safetyTextResource.valueOutOfRange(0.0, "", 65535.0);
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.profisafeSourceAddressField = wf.createNumberField(e -> this.getProfisafeConfiguration().setSourceAddress(((Double)this.profisafeSourceAddressField.getValue()).intValue()));
        this.profisafeSourceAddressField.setEnabled(false);
        this.profisafeSourceAddressField.setName(PROFISAFE_SOURCE_ADDRESS);
        this.profisafeSourceAddressField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"######"));
        this.profisafeSourceAddressField.setMode(Mode.PositiveWholeNumbers);
        this.profisafeSourceAddressField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)65535.0, (boolean)true, (String)errorMessage)});
    }

    private void initEnabledField() {
        this.profisafeEnabledSwitch = new OnOffSwitch(this.safetyTextResource.profisafeEnable());
        this.profisafeEnabledSwitch.setEnabled(false);
        this.profisafeEnabledSwitch.setName(PROFISAFE_ENABLED);
        this.profisafeEnabledSwitch.addActionListener((ActionListener)new EnableProfisafeAction());
    }

    private void stopProfinetMonitor() {
        this.profinetTaskMonitor = null;
    }

    protected void showProfinetTooltipIfDaemonIsRunning(boolean enabled) {
        if (!enabled && this.isProfinetDaemonRunning()) {
            this.profinetNotDisabledTooltip.showProfinetNotDisabledTooltip();
        }
    }

    private void update() {
        this.profisafeEnabledSwitch.setSelected(this.isProfisafeEnabled());
        if (this.isProfisafeEnabled()) {
            this.profisafeSourceAddressField.setValue((Object)this.getProfisafeConfiguration().getSourceAddress());
            this.profisafeDestinationAddressField.setValue((Object)this.getProfisafeConfiguration().getDestinationAddress());
            this.profisafeOperationalModeSwitch.setSelected(this.getProfisafeConfiguration().isOperationalModeEnabled());
        } else {
            this.resetSettings();
        }
        this.operationalModeMessage.setVisible(this.showOperationalModeWarning());
        this.licenseWarningMessage.setVisible(!this.hasProfisafeLicense());
        this.buildAndUpdateLayout();
    }

    private boolean showOperationalModeWarning() {
        return !this.profisafeOperationalModeSwitch.isSelected() && this.getSafetyIOConfiguration().getOperationalModeInputs().isAssigned();
    }

    @Override
    public void activate() {
        this.update();
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void reset() {
        this.update();
        this.updateProfinetUIState(this.isProfisafeEnabled());
        this.updateProfinetMonitor(this.isProfisafeEnabled());
    }

    private void updateProfinetUIState(boolean isProfisafeEnabled) {
        if (isProfisafeEnabled) {
            this.profinetService.setProfinetUIState(ProfinetUIState.DISABLED);
        } else {
            this.profinetService.setProfinetUIState(ProfinetUIState.ENABLED);
        }
    }

    @Override
    public void doUnlock() {
        if (this.hasProfisafeLicense() || this.isProfisafeEnabled()) {
            this.updatePrimaryFields(true);
            if (this.isProfisafeEnabled()) {
                this.updateSecondaryFields(true);
            }
        }
    }

    @Override
    public void doLock() {
        this.updatePrimaryFields(false);
        this.updateSecondaryFields(false);
    }

    private void updatePrimaryFields(boolean enabled) {
        this.profisafeEnabledSwitch.setEnabled(enabled);
    }

    private void updateSecondaryFields(boolean enabled) {
        this.profisafeSourceAddressField.setEnabled(enabled);
        this.profisafeDestinationAddressField.setEnabled(enabled);
        this.profisafeOperationalModeSwitch.setEnabled(enabled);
    }

    private void resetSettings() {
        this.profisafeSourceAddressField.setValue((Object)0.0);
        this.getProfisafeConfiguration().setSourceAddress(0);
        this.profisafeDestinationAddressField.setValue((Object)0.0);
        this.getProfisafeConfiguration().setDestinationAddress(0);
        this.profisafeOperationalModeSwitch.setSelected(false);
        this.getProfisafeConfiguration().setOperationalModeEnabled(false);
    }

    private boolean hasProfisafeLicense() {
        return this.licenseManager.isFeatureActive("profisafe");
    }

    private boolean isProfisafeEnabled() {
        return this.getProfisafeConfiguration().isEnabled();
    }

    private ProfisafeConfiguration getProfisafeConfiguration() {
        return this.safetySettingsLookupService.getSafetyComponent(ProfisafeConfiguration.class);
    }

    private SafetyIOConfiguration getSafetyIOConfiguration() {
        return this.safetySettingsLookupService.getSafetyComponent(SafetyIOConfiguration.class);
    }

    @Override
    public void onProfinetDaemonError() {
        this.profisafeEnabledSwitch.setSelected(false);
        new EnableProfisafeAction().actionPerformed(null);
        this.stopProfinetMonitor();
    }

    @Override
    public void onProfinetDaemonSuccess() {
        this.profinetService.setProfinetUIState(ProfinetUIState.DISABLED);
        this.stopProfinetMonitor();
    }

    private void updateProfinetMonitor(boolean enabled) {
        if (enabled) {
            this.profinetTaskMonitor = (ProfinetTaskMonitor)this.startProfinetAndMonitorProvider.get();
            new Thread(this.profinetTaskMonitor).start();
        } else {
            this.stopProfinetMonitor();
        }
    }

    private boolean isProfinetDaemonRunning() {
        ProfinetDaemonState profinetDaemonState = this.profinetService.getProfinetDaemonState();
        switch (profinetDaemonState) {
            case STARTING: 
            case CONNECTING: 
            case RUNNING: {
                return true;
            }
        }
        return false;
    }

    private class EnableProfisafeAction
    implements ActionListener {
        private EnableProfisafeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfisafePanel.this.getProfisafeConfiguration().setEnabled(ProfisafePanel.this.profisafeEnabledSwitch.isSelected());
            ProfisafePanel.this.updateProfinetMonitor(ProfisafePanel.this.profisafeEnabledSwitch.isSelected());
            ProfisafePanel.this.updateProfinetUIState(ProfisafePanel.this.profisafeEnabledSwitch.isSelected());
            ProfisafePanel.this.updateSecondaryFields(ProfisafePanel.this.profisafeEnabledSwitch.isSelected());
            ProfisafePanel.this.showProfinetTooltipIfDaemonIsRunning(ProfisafePanel.this.profisafeEnabledSwitch.isSelected());
            if (!ProfisafePanel.this.profisafeEnabledSwitch.isSelected()) {
                ProfisafePanel.this.resetSettings();
            }
            ProfisafePanel.this.buildAndUpdateLayout();
        }
    }
}

