/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.recovery;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.JointPaintStrategy;
import com.ur.move.MoveTabPanel;
import com.ur.move.MoveTabPointStrategy;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.safety.recovery.RecoverTooltip;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.SafetyMode;
import javax.inject.Inject;

public class RecoveryMoveTabStrategy
implements MoveTabPointStrategy {
    private final RecoverTooltip tooltip;

    @Inject
    public RecoveryMoveTabStrategy(RecoverTooltip tooltip) {
        this.tooltip = tooltip;
    }

    public boolean useStrategy(Object o) {
        return o == SafetyMode.RECOVERY;
    }

    public void setPosition(Object o, RobotState robotState) {
        this.tooltip.setVisible(false);
    }

    public void onEnter(Object o, JointPaintStrategy paintJointsStrategy, MoveTabPanel moveTabPanel) {
        paintJointsStrategy.hideTargetPositions();
        this.tooltip.setVisible(true);
        moveTabPanel.showOkCancelPanel();
        moveTabPanel.setOKCancelEnabled(false, true);
        EventNotificationService.register((Object)this, RobotStateListener.class, (Object)new RecoveryModeListener(moveTabPanel));
    }

    public void onExit() {
        this.tooltip.setVisible(false);
        EventNotificationService.unregister((Object)this, RobotStateListener.class);
    }

    public JointPositionVector getShadowJPV(Object o) {
        return null;
    }

    public boolean hasVisualComponent() {
        return true;
    }

    public J3DComponent getComponent() {
        return this.tooltip;
    }

    private class RecoveryModeListener
    implements RobotStateListener {
        private final MoveTabPanel moveTabPanel;
        SafetyMode currentState = null;

        public RecoveryModeListener(MoveTabPanel moveTabPanel) {
            this.moveTabPanel = moveTabPanel;
        }

        public void updateRobotState(RobotState robotState) {
            if (robotState.masterSafetyState != this.currentState) {
                switch (robotState.masterSafetyState) {
                    case RECOVERY: {
                        this.moveTabPanel.setOKCancelEnabled(false, true);
                        break;
                    }
                    case NORMAL: 
                    case REDUCED: {
                        this.moveTabPanel.setOKCancelEnabled(true, false);
                    }
                }
                this.currentState = robotState.masterSafetyState;
            }
        }
    }
}

