/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome;

import com.ur.bean.PropertyChangeSite;
import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.viewfacade.lang.URMath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class SafeHomeConfiguration
implements PropertyChangeSite,
SafetySetupComponent {
    private final transient URPropertyChangeSupport changeSupport;
    public static final float[] DEFAULT_POSITION = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    private float[] safeHomePosition = DEFAULT_POSITION;
    private boolean safeHomeEnabled;

    public SafeHomeConfiguration() {
        this.changeSupport = new URPropertyChangeSupport((Object)this);
    }

    public float[] getSafeHomePosition() {
        return this.safeHomePosition;
    }

    public void setSafeHomePositionFromJointPositionVector(JointPositionVector jointPositionVector) {
        this.setSafeHomePosition(URMath.unwrapJointPositionVector((JointPositionVector)jointPositionVector));
    }

    public boolean isSafeHomeSyncedToHome(JointPositionVector homePositionVector) {
        float[] safeHomePosition = this.getSafeHomePosition();
        float[] homePositionUnwrap = URMath.unwrapJointPositionVector((JointPositionVector)homePositionVector);
        return URMath.arrayEpsilonEquals((float[])safeHomePosition, (float[])homePositionUnwrap, (float)1.0E-5f);
    }

    public void setSafeHomeEnabled(boolean safeHomeEnabled) {
        boolean oldSafeHomeEnabled = this.safeHomeEnabled;
        this.safeHomeEnabled = safeHomeEnabled;
        this.fireEvent(new PropertyChangeEvent(this, "safeHomeEnabled", oldSafeHomeEnabled, this.safeHomeEnabled));
    }

    public void setSafeHomePosition(float[] safeHomePosition) {
        float[] oldSafeHomePosition = this.safeHomePosition;
        this.safeHomePosition = safeHomePosition;
        this.fireEvent(new PropertyChangeEvent(this, "safeHomePosition", oldSafeHomePosition, safeHomePosition));
    }

    public boolean isEnabled() {
        return this.safeHomeEnabled;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void fireEvent(PropertyChangeEvent propertyChangeEvent) {
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }

    public boolean completelyEquals(Object other) {
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public boolean isReducedModeDefined() {
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }
}

