/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome;

import com.ur.lang.EndianConverter;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyEndianConverter;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.safety.safehome.SafeHomeConfiguration;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class SafeHomeConfigurationParser
extends SafetyConfigurationParser.ActiveParserTemplate<SafeHomeConfiguration> {
    private SafeHomeConfiguration result;
    private EndianConverter endianConverter;

    @Inject
    public SafeHomeConfigurationParser(SafetyEndianConverter safetyEndianConverter) {
        this.endianConverter = safetyEndianConverter.getConverter();
    }

    @Override
    public void parse(DataInput input, ChecksumVersion version) throws IOException {
        if (version.before(ChecksumVersion.VERSION_5_2)) {
            return;
        }
        this.result = new SafeHomeConfiguration();
        if (version.atLeast(ChecksumVersion.VERSION_5_6)) {
            this.parseSafeHomeEnabled(input);
        }
        this.parseJointPositions(input);
    }

    private void parseSafeHomeEnabled(DataInput input) throws IOException {
        this.result.setSafeHomeEnabled(input.readByte() == 1);
    }

    private void parseJointPositions(DataInput stream) throws IOException {
        float[] jointPositions = new float[JointType.values().length];
        int i = 0;
        while (i < jointPositions.length) {
            jointPositions[i] = this.endianConverter.getFloat(stream);
            ++i;
        }
        this.result.setSafeHomePosition(jointPositions);
    }

    @Override
    public Class<SafeHomeConfiguration> getType() {
        return SafeHomeConfiguration.class;
    }

    @Override
    public SafeHomeConfiguration getResult() {
        return this.result;
    }
}

