/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.safehome.SafeHomeConfiguration;
import java.util.Arrays;

public class SafeHomeContribution
implements SafetySetupContribution<SafeHomeConfiguration> {
    private static final String SAFE_HOME_SECTION_NAME = "SafeHome";
    static final String SAFE_HOME_POSITION = "safeHomePosition";
    static final String SAFE_HOME_ENABLED = "safeHomeEnabled";

    public Class<SafeHomeConfiguration> getComponentType() {
        return SafeHomeConfiguration.class;
    }

    public SafeHomeConfiguration createDefaultComponent() {
        return new SafeHomeConfiguration();
    }

    public SafeHomeConfiguration readFromOptions(ChecksumVersion checksumVersion, Options options) {
        SafeHomeConfiguration component = this.createDefaultComponent();
        OptionsSection section = options.getSection(SAFE_HOME_SECTION_NAME);
        if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_6)) {
            component.setSafeHomeEnabled(section.getInteger(SAFE_HOME_ENABLED, Integer.valueOf(0)).equals(1));
        }
        component.setSafeHomePosition(section.getFloatArray(SAFE_HOME_POSITION, SafeHomeConfiguration.DEFAULT_POSITION));
        if (!checksumVersion.atLeast(ChecksumVersion.VERSION_5_6) && !Arrays.equals(component.getSafeHomePosition(), SafeHomeConfiguration.DEFAULT_POSITION)) {
            component.setSafeHomeEnabled(true);
        }
        return component;
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafeHomeConfiguration component) {
        this.copyTo(options, checksumVersion, component);
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafeHomeConfiguration component) {
        this.copyTo(options, checksumVersion, component);
    }

    private void copyTo(Options options, ChecksumVersion checksumVersion, SafeHomeConfiguration component) {
        OptionsSection section = options.getSection(SAFE_HOME_SECTION_NAME);
        if (checksumVersion.atLeast(ChecksumVersion.VERSION_5_6)) {
            section.setInteger(SAFE_HOME_ENABLED, Integer.valueOf(component.isEnabled() ? 1 : 0));
        }
        section.setFloatArray(SAFE_HOME_POSITION, component.getSafeHomePosition());
    }

    public boolean isSupported(ChecksumVersion checksumVersion) {
        return checksumVersion.atLeast(ChecksumVersion.VERSION_5_2);
    }
}

