/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.infrastructure.BoundariesPanelImpl;
import com.ur.safety.safehome.SafeHomePresenter;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.FormBuilder;
import com.ur.swing.TooltipFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.units.Units;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SafeHomePanel
extends ActivatablePanel {
    public static final String SHOW_SAFE_HOME_ACTION = "showSafeHomeAction." + SafeHomePanel.class.getSimpleName();
    public static final String SYNC_SAFE_HOME = "syncSafeHome." + SafeHomePanel.class.getSimpleName();
    public static final String DELETE_SAFE_HOME = "deleteSafeHome." + SafeHomePanel.class.getSimpleName();
    private static final DecimalFormat degFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    private SafeHomePresenter presenter;
    private final ViewContext viewContext;
    private final VisualizerFactory visualizerFactory;
    private final TextResource moveTextResource;
    private final SafetyTextResource safetyTextResource;
    private TooltipFactory tooltipFactory;
    private JPanel graphicsPanel = new JPanel();
    private JPanel syncPanel;
    private JPanel jointPositionPanel;
    private Component robotCanvas;
    private JLabel joint1ValueLabel;
    private JLabel joint2ValueLabel;
    private JLabel joint3ValueLabel;
    private JLabel joint4ValueLabel;
    private JLabel joint5ValueLabel;
    private JLabel joint6ValueLabel;
    private JLabel[] jointValueLabels = new JLabel[6];
    private JButton syncPositionButton;
    private JButton deleteSafeHomePositionButton;
    private JLabel syncWarningLabel;

    @Inject
    public SafeHomePanel(SafeHomePresenter presenter, ViewContext viewContext, VisualizerFactory visualizerFactory, TooltipFactory tooltipFactory) {
        this.presenter = presenter;
        this.viewContext = viewContext;
        this.visualizerFactory = visualizerFactory;
        this.moveTextResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.safetyTextResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.tooltipFactory = tooltipFactory;
        this.initComponents();
        presenter.setView(this);
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.graphicsPanel, "gui:installation_Safe_Home_Position");
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.syncPanel, "gui:installation_Syncing_from_Home");
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)this.jointPositionPanel, "gui:installation_Safe_Home_Position");
    }

    private void initComponents() {
        this.setBackground(BoundariesPanelImpl.BETWEEN_CARD_COLOR);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder());
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.syncWarningLabel = new JLabel();
        this.syncPanel = this.createSyncPanel(widgetFactory);
        this.jointPositionPanel = this.createJointPositionPanel();
        JPanel rightSidePanel = new JPanel(new BorderLayout(0, 5));
        rightSidePanel.setMinimumSize(new Dimension(320, -1));
        rightSidePanel.setPreferredSize(new Dimension(320, -1));
        rightSidePanel.setBackground(BoundariesPanelImpl.BETWEEN_CARD_COLOR);
        rightSidePanel.add((Component)this.syncPanel, "Center");
        rightSidePanel.add((Component)this.jointPositionPanel, "South");
        this.robotCanvas = this.visualizerFactory.createCanvas();
        this.visualizerFactory.setDebugName(this.robotCanvas, "Safe Home 3D Canvas");
        this.robotCanvas.setVisible(false);
        this.graphicsPanel.setLayout(new BorderLayout());
        this.graphicsPanel.add(this.robotCanvas, "Center");
        this.graphicsPanel.setBorder((Border)new CardBorder(this.safetyTextResource.Robot()));
        this.add((Component)rightSidePanel, "East");
        this.add((Component)this.graphicsPanel, "Center");
    }

    private JPanel createJointPositionPanel() {
        this.joint1ValueLabel = new JLabel();
        this.joint2ValueLabel = new JLabel();
        this.joint3ValueLabel = new JLabel();
        this.joint4ValueLabel = new JLabel();
        this.joint5ValueLabel = new JLabel();
        this.joint6ValueLabel = new JLabel();
        this.addJComponentsToArrays();
        this.setLabelProperties();
        return this.viewContext.createFormBuilder().label(this.moveTextResource.joint0Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint1ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint1Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint2ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint2Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint3ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint3Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint4ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint4Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint5ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint5Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint6ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().getCardPanel(String.valueOf(this.moveTextResource.jointPosition()) + " (0-360" + Units.getText().unitDegrees() + ")");
    }

    private void addJComponentsToArrays() {
        this.jointValueLabels[0] = this.joint1ValueLabel;
        this.jointValueLabels[1] = this.joint2ValueLabel;
        this.jointValueLabels[2] = this.joint3ValueLabel;
        this.jointValueLabels[3] = this.joint4ValueLabel;
        this.jointValueLabels[4] = this.joint5ValueLabel;
        this.jointValueLabels[5] = this.joint6ValueLabel;
    }

    private void setLabelProperties() {
        JLabel[] jLabelArray = this.jointValueLabels;
        int n = this.jointValueLabels.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel jointValueLabel = jLabelArray[n2];
            jointValueLabel.setHorizontalAlignment(4);
            ++n2;
        }
    }

    private JPanel createSyncPanel(WidgetFactory widgetFactory) {
        this.syncPositionButton = widgetFactory.createButton((Action)((Object)new SyncSafeHomePositionAction()));
        this.syncPositionButton.setIcon(ViewImageResource.refreshSmall());
        this.syncPositionButton.setText(this.safetyTextResource.syncSafeHomeButton());
        this.syncPositionButton.setName(SYNC_SAFE_HOME);
        this.deleteSafeHomePositionButton = widgetFactory.createButton((Action)((Object)new RemoveSafeHomePositionAction()));
        this.deleteSafeHomePositionButton.setText(this.safetyTextResource.Delete());
        this.deleteSafeHomePositionButton.setName(DELETE_SAFE_HOME);
        return this.viewContext.createFormBuilder().component((JComponent)this.syncPositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().end().component((JComponent)this.deleteSafeHomePositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().end().description(HTML.html((String)this.safetyTextResource.safeHomeDeleteDescription()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).component((JComponent)this.syncWarningLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getCardPanel(this.safetyTextResource.safeHome());
    }

    protected void setJointsValueLabels(float[] jointPositions, boolean visible) {
        if (jointPositions != null) {
            int i = 0;
            while (i < this.jointValueLabels.length) {
                this.jointValueLabels[i].setText(degFormat.format((double)jointPositions[i] * 57.29577951308232) + Units.getText().unitDegrees());
                this.jointValueLabels[i].setVisible(visible);
                ++i;
            }
        }
    }

    JLabel[] getJointValueLabels() {
        return this.jointValueLabels;
    }

    protected void enableComponents(boolean enabled) {
        this.syncPositionButton.setEnabled(enabled);
        this.deleteSafeHomePositionButton.setEnabled(enabled && this.presenter.getConfiguration().isEnabled());
    }

    protected void setRobotCanvasVisible(boolean visible) {
        this.robotCanvas.setVisible(visible);
    }

    protected void setVisualizedRobotPosition(float[] position) {
        JointPositionVector jointPositionVector = new JointPositionVector((double)position[0], (double)position[1], (double)position[2], (double)position[3], (double)position[4], (double)position[5]);
        this.visualizerFactory.showRobot(this.robotCanvas, jointPositionVector);
    }

    protected void showHomePositionTooltip() {
        this.tooltipFactory.showInformationTooltipCloseAnyClick((JComponent)this.syncPositionButton, this.safetyTextResource.homePositionNotSetTooltip());
    }

    public void setSyncHint(boolean synced) {
        if (synced) {
            this.syncPositionButton.setText(String.valueOf(this.safetyTextResource.syncSafeHomeButton()));
            this.syncWarningLabel.setIcon(null);
            this.syncWarningLabel.setText("");
        } else {
            this.syncPositionButton.setText(String.valueOf(this.safetyTextResource.syncSafeHomeButton()) + "*");
            this.syncWarningLabel.setIcon(ViewImageResource.formWarning());
            this.syncWarningLabel.setText(HTML.html((String)this.safetyTextResource.syncSafeHomeWarning()));
        }
    }

    @Override
    public void activate() {
        this.presenter.activate();
    }

    @Override
    public void deactivate() {
        this.setRobotCanvasVisible(false);
    }

    private class RemoveSafeHomePositionAction
    extends AbstractActionDefinition {
        private RemoveSafeHomePositionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SafeHomePanel.this.presenter.deleteSafeHomePosition();
        }
    }

    private class SyncSafeHomePositionAction
    extends AbstractActionDefinition {
        private SyncSafeHomePositionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SafeHomePanel.this.presenter.syncSafeHomePosition();
        }
    }
}

