/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.io.SafetyIOOutputFunction;
import com.ur.safety.safehome.SafeHomeConfiguration;
import com.ur.safety.safehome.SafeHomePanel;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.util.event.EventManager;
import com.ur.view.polyscope.persistence.installation.safehome.SafeHomeSettings;
import gui.installation.HomeOrSafeHomeChangedListener;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SafeHomePresenter
implements ReloadOnSafetyLoaded {
    private SafeHomeConfiguration configuration;
    private final SafetySettingsLookupService provider;
    private final EnableSafeHomeView enablement;
    private SafeHomePanel view;
    private final InstallationComponentLookup lookupService;
    private final EventManager eventManager;

    @Inject
    public SafeHomePresenter(SafetySettingsLookupService provider, EnableSafeHomeView enablement, InstallationComponentLookup lookupService, EventManager eventManager) {
        this.provider = provider;
        this.enablement = enablement;
        this.lookupService = lookupService;
        this.eventManager = eventManager;
    }

    public void setView(SafeHomePanel view) {
        this.configuration = this.provider.getSafetyComponent(SafeHomeConfiguration.class);
        this.view = view;
        this.enablement.setView(view);
        this.activate();
    }

    public void activate() {
        if (this.view.isShowing()) {
            this.configuration = this.getConfiguration();
            this.view.setRobotCanvasVisible(this.configuration.isEnabled());
            this.view.setVisualizedRobotPosition(this.configuration.getSafeHomePosition());
            this.view.setJointsValueLabels(this.configuration.getSafeHomePosition(), this.configuration.isEnabled());
            this.view.setSyncHint(this.isSyncedToHome());
            this.enablement.updateEnablement();
        }
    }

    public SafeHomeConfiguration getConfiguration() {
        return this.provider.getSafetyComponent(SafeHomeConfiguration.class);
    }

    public void deleteSafeHomePosition() {
        SafetyIOConfiguration ioConfiguration = this.provider.getSafetyComponent(SafetyIOConfiguration.class);
        ioConfiguration.setOutput(ioConfiguration.getSafeHomeOutputs(), SafetyIOOutputFunction.UNASSIGNED);
        this.configuration.setSafeHomeEnabled(false);
        this.configuration.setSafeHomePosition(SafeHomeConfiguration.DEFAULT_POSITION);
        this.notifyPositionHasChanged();
        this.activate();
    }

    public SafeHomeSettings getSafeHomeSettings() {
        return (SafeHomeSettings)this.lookupService.getComponent(SafeHomeSettings.class);
    }

    public boolean isSyncedToHome() {
        SafeHomeSettings safeHomeSettings = this.getSafeHomeSettings();
        return this.configuration.isSafeHomeSyncedToHome(safeHomeSettings.getPosition());
    }

    public void syncSafeHomePosition() {
        SafeHomeSettings safeHomeSettings = (SafeHomeSettings)this.lookupService.getComponent(SafeHomeSettings.class);
        if (safeHomeSettings.isEnabled()) {
            this.configuration.setSafeHomePositionFromJointPositionVector(safeHomeSettings.getPosition());
            this.configuration.setSafeHomeEnabled(true);
            this.notifyPositionHasChanged();
            this.activate();
        } else {
            this.view.showHomePositionTooltip();
        }
    }

    private void notifyPositionHasChanged() {
        this.eventManager.fireEvent(HomeOrSafeHomeChangedListener.class, HomeOrSafeHomeChangedListener::homeOrSafeHomeChanged);
    }

    @Override
    public void reset() {
        this.activate();
    }

    @Singleton
    static class EnableSafeHomeView
    implements SafetyLockListener {
        private SafetyLock safetyLock;
        private SafeHomePanel view;

        @Inject
        public EnableSafeHomeView(SafetyLock safetyLock) {
            this.safetyLock = safetyLock;
            safetyLock.addSafetyLockListener(this);
        }

        public void setView(SafeHomePanel view) {
            this.view = view;
            this.updateEnablement();
        }

        public void updateEnablement() {
            this.view.enableComponents(!this.safetyLock.isLocked());
        }

        @Override
        public void doUnlock() {
            this.view.enableComponents(true);
        }

        @Override
        public void doLock() {
            this.view.enableComponents(false);
        }
    }
}

