/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.AbstractSafetySetupToHtmlRenderer;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.safehome.SafeHomeConfiguration;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.swing.HTML;
import java.text.DecimalFormat;
import javax.inject.Inject;

public class SafeHomeToHtmlRenderer
extends AbstractSafetySetupToHtmlRenderer {
    private UnitsConverter jointPositionConverter;
    private DecimalFormat degFormat;
    private AlternatingBackgroundRowGenerator rowGenerator;

    @Inject
    public SafeHomeToHtmlRenderer(SafetyTextResource translation, SafetySetupPanesLookAndFeel lookAndFeel) {
        super(translation, lookAndFeel);
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        this.jointPositionConverter = useSIUnits ? Units.getRadiansConverter() : Units.getDegreesConverter();
        String pattern = useSIUnits ? "##0.0000" : "##0.00";
        this.degFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)pattern);
        this.rowGenerator = new AlternatingBackgroundRowGenerator();
        return new HTMLPage(this.textResource.safeHome(), this.createSafeHomeHTML((SafeHomeConfiguration)safetySetup.getComponent(SafeHomeConfiguration.class)));
    }

    private String createSafeHomeHTML(SafeHomeConfiguration safeHomeConfiguration) {
        if (safeHomeConfiguration.isEnabled()) {
            return HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.textResource.jointColumnHeader()), HTML.tableHeaderWithProperties((String)"align=center colspan=2 nowrap", (String)this.textResource.Position())}), this.jointPositionRow(this.textResource.joint0Name(), 0, safeHomeConfiguration), this.jointPositionRow(this.textResource.joint1Name(), 1, safeHomeConfiguration), this.jointPositionRow(this.textResource.joint2Name(), 2, safeHomeConfiguration), this.jointPositionRow(this.textResource.joint3Name(), 3, safeHomeConfiguration), this.jointPositionRow(this.textResource.joint4Name(), 4, safeHomeConfiguration), this.jointPositionRow(this.textResource.joint5Name(), 5, safeHomeConfiguration)});
        }
        return HTML.html((String)HTML.h2((String)this.textResource.safeHomeNotSet()));
    }

    private String jointPositionRow(String jointName, int jointNumber, SafeHomeConfiguration safeHomeConfiguration) {
        return this.rowGenerator.generate(HTML.tableCell((String)jointName), HTML.tableCellNumber((String)this.getJointPosition(jointNumber, safeHomeConfiguration)), HTML.tableCell((String)this.jointPositionConverter.getUnit()));
    }

    private String getJointPosition(int joint, SafeHomeConfiguration configuration) {
        return this.degFormat.format(this.jointPositionConverter.convertFrom((double)configuration.getSafeHomePosition()[joint]));
    }
}

