/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome.infrastructure;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.util.event.EventNotificationService;

public class InstallationComponentCardPanel<X extends InstallationComponent>
extends CardPanel {
    private InstallationComponentLookup lookupService;
    private ViewContext viewContext;
    private Class<X> installationComponentClass;
    protected boolean isUpdatingCard = false;

    public InstallationComponentCardPanel(InstallationComponentLookup lookupService, ViewContext viewContext, Class<X> installationComponentClass) {
        this.lookupService = lookupService;
        this.viewContext = viewContext;
        this.installationComponentClass = installationComponentClass;
    }

    protected ViewContext getViewContext() {
        return this.viewContext;
    }

    protected X getInstallationComponent() {
        return (X)this.lookupService.getComponent(this.installationComponentClass);
    }

    protected void updateCard(X installationComponent) {
    }

    protected boolean isUpdatingCard() {
        return this.isUpdatingCard;
    }

    public void enter(Object o) {
        this.isUpdatingCard = true;
        this.updateCard(this.getInstallationComponent());
        this.isUpdatingCard = false;
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                InstallationComponentCardPanel.this.isUpdatingCard = true;
                InstallationComponentCardPanel.this.updateCard(InstallationComponentCardPanel.this.getInstallationComponent());
                InstallationComponentCardPanel.this.isUpdatingCard = false;
            }
        });
        super.enter(o);
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        return super.exit();
    }
}

