/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.MoveRequestImpl;
import com.ur.move.MoveToAction;
import com.ur.move.automove.AutoMoveTab;
import com.ur.move.automove.AutoMoveTitleComposite;
import com.ur.polyscope.move.AutoMoveCallback;
import com.ur.polyscope.move.MoveRequest;
import com.ur.polyscope.move.MoveRequestErrorType;
import com.ur.polyscope.robot.configuration.putinbox.PutInBoxConfiguration;
import com.ur.polyscope.robot.configuration.putinbox.PutInBoxConfigurationProvider;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.safety.SafetyImageResource;
import com.ur.safety.safehome.infrastructure.SafeHomeInstallationCardPanel;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.inject.Inject;

public class PutInBoxMoveToAction
extends MoveToAction {
    private final TextResource textResource;
    private final PutInBoxConfigurationProvider putInBoxConfigurationProvider;

    @Inject
    public PutInBoxMoveToAction(TextResource textResource, PutInBoxConfigurationProvider putInBoxConfigurationProvider) {
        super(textResource.putInBox(), SafetyImageResource.putInBox(), SafeHomeInstallationCardPanel.PUT_IN_BOX);
        this.textResource = textResource;
        this.putInBoxConfigurationProvider = putInBoxConfigurationProvider;
    }

    public JointPositionVector getJointPositionVector() {
        Optional putInBoxConfiguration = this.putInBoxConfigurationProvider.getPutInBoxConfiguration();
        if (putInBoxConfiguration.isPresent()) {
            return ((PutInBoxConfiguration)putInBoxConfiguration.get()).getJointPositions();
        }
        throw new IllegalStateException("Put in box configuration is not present");
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.robotStateRequirement.checkAndNotify()) {
            AutoMoveTitleComposite composite = new AutoMoveTitleComposite((Object)this.getMoveRequest(new PutInBoxAutoMoveCallback(this::onCompletion)), this.textResource.zeroPosition());
            this.cardPanel.stackCurrentCardAndSwitchTo(AutoMoveTab.class, (Object)composite);
        }
    }

    private JointConfiguration getZeroPosition() {
        return new JointConfiguration(0.0, -1.5707963267948966, 0.0, -1.5707963267948966, 0.0, 0.0);
    }

    private void onCompletion() {
        if (this.robotStateRequirement.checkAndNotify()) {
            AutoMoveTitleComposite composite = new AutoMoveTitleComposite((Object)this.getJointPositionVector(), this.textResource.putInBox());
            this.cardPanel.stackCurrentCardAndSwitchTo(AutoMoveTab.class, (Object)composite);
        }
    }

    private MoveRequest getMoveRequest(AutoMoveCallback callback) {
        return new MoveRequestImpl(this.getZeroPosition(), null, callback);
    }

    private static class PutInBoxAutoMoveCallback
    implements AutoMoveCallback {
        private final Runnable onCompletion;

        public PutInBoxAutoMoveCallback(Runnable onCompletion) {
            this.onCompletion = onCompletion;
        }

        public void onComplete() {
            this.onCompletion.run();
        }

        public void onCancel() {
        }

        public void onError(MoveRequestErrorType moveRequestErrorType) {
        }
    }
}

