/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.safehome.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveToAction;
import com.ur.move.SafeHomeMoveToAction;
import com.ur.move.resources.TextResource;
import com.ur.polyscope.initializerobot.poweron.PoweredOnRobotRequirement;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.safety.safehome.infrastructure.InstallationComponentCardPanel;
import com.ur.safety.safehome.infrastructure.PutInBoxMoveToAction;
import com.ur.safety.safehome.infrastructure.ZeroJointMoveToAction;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.units.Units;
import com.ur.util.event.EventManager;
import com.ur.view.polyscope.persistence.installation.safehome.SafeHomeSettings;
import gui.installation.HomeOrSafeHomeChangedListener;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SafeHomeInstallationCardPanel
extends InstallationComponentCardPanel<SafeHomeSettings> {
    public static final String SHOW_SAFE_HOME_ACTION = "showSafeHomeAction." + SafeHomeInstallationCardPanel.class.getSimpleName();
    private static final DecimalFormat degFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##0.00");
    private static final double DEGREES_PER_RAD = 57.29577951308232;
    private static final Color BETWEEN_CARD_COLOR = UIManager.getColor("CardPanel.background");
    public static final String SET_POSITION = "setPosition." + SafeHomeInstallationCardPanel.class.getSimpleName();
    public static final String ZERO_POSITION = "zeroPosition." + SafeHomeInstallationCardPanel.class.getSimpleName();
    public static final String PUT_IN_BOX = "putInBox." + SafeHomeInstallationCardPanel.class.getSimpleName();
    private ViewContext viewContext;
    private PositionRequester positionRequester;
    private Component robotCanvas;
    private final JLabel[] jointValueLabels = new JLabel[6];
    private JLabel joint1ValueLabel;
    private JLabel joint2ValueLabel;
    private JLabel joint3ValueLabel;
    private JLabel joint4ValueLabel;
    private JLabel joint5ValueLabel;
    private JLabel joint6ValueLabel;
    private JPanel graphicsPanel = new JPanel();
    private JPanel editPositionPanel;
    private JPanel predefinedPositionPanel;
    private JPanel jointPositionPanel;
    private JButton setPositionButton;
    private JButton moveHereButton;
    private JButton zeroPositionButton;
    private JButton putInBoxButton;
    private VisualizerFactory visualizerFactory;
    private PoweredOnRobotRequirement poweredOnRobotRequirement;
    private SafeHomeMoveToAction safeHomeMoveToAction;
    private TextResource moveTextResource;
    private com.ur.i18n.TextResource textResource;
    private EventManager eventManager;
    private final HelpIdAssigner helpIdAssigner;
    private final PutInBoxMoveToAction putInBoxMoveToAction;

    @Inject
    public SafeHomeInstallationCardPanel(InstallationComponentLookup lookupService, ViewContext viewContext, PositionRequester positionRequester, VisualizerFactory visualizerFactory, PoweredOnRobotRequirement poweredOnRobotRequirement, SafeHomeMoveToAction safeHomeMoveToAction, EventManager eventManager, HelpIdAssigner helpIdAssigner, PutInBoxMoveToAction putInBoxMoveToAction) {
        super(lookupService, viewContext, SafeHomeSettings.class);
        this.viewContext = viewContext;
        this.positionRequester = positionRequester;
        this.visualizerFactory = visualizerFactory;
        this.poweredOnRobotRequirement = poweredOnRobotRequirement;
        this.safeHomeMoveToAction = safeHomeMoveToAction;
        this.helpIdAssigner = helpIdAssigner;
        this.moveTextResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.textResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.eventManager = eventManager;
        this.putInBoxMoveToAction = putInBoxMoveToAction;
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.graphicsPanel, "gui:installation_Home");
        this.helpIdAssigner.assignHelpId((JComponent)this.editPositionPanel, "gui:installation_Home");
        this.helpIdAssigner.assignHelpId((JComponent)this.jointPositionPanel, "gui:installation_Home");
    }

    private void initComponents() {
        this.setBackground(BETWEEN_CARD_COLOR);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder());
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        JPanel leftSideView = new JPanel(new BorderLayout(0, 5));
        leftSideView.setBackground(BETWEEN_CARD_COLOR);
        this.editPositionPanel = this.createEditPositionPanel(widgetFactory);
        this.predefinedPositionPanel = this.createPredefinedPositionPanel();
        this.jointPositionPanel = this.createJointPositionPanel();
        leftSideView.add((Component)this.editPositionPanel, "North");
        leftSideView.add((Component)this.predefinedPositionPanel, "Center");
        leftSideView.add((Component)this.jointPositionPanel, "South");
        leftSideView.setPreferredSize(new Dimension(350, 0));
        this.robotCanvas = this.visualizerFactory.createCanvas();
        this.visualizerFactory.setDebugName(this.robotCanvas, "Safe Home Safety Card 3D Canvas");
        this.robotCanvas.setVisible(false);
        this.graphicsPanel.setLayout(new BorderLayout());
        this.graphicsPanel.add(this.robotCanvas, "Center");
        this.graphicsPanel.setBorder((Border)new CardBorder(this.textResource.Robot()));
        this.add(leftSideView, "West");
        this.add(this.graphicsPanel, "Center");
    }

    private JPanel createPredefinedPositionPanel() {
        ZeroJointMoveToAction zeroJointMoveToAction = new ZeroJointMoveToAction(this.textResource);
        this.zeroPositionButton = this.createMoveToButton(this.poweredOnRobotRequirement, zeroJointMoveToAction);
        this.putInBoxButton = this.createMoveToButton(this.poweredOnRobotRequirement, this.putInBoxMoveToAction);
        return this.viewContext.createFormBuilder().component((JComponent)this.zeroPositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().end().component((JComponent)this.putInBoxButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().getCardPanel("Predefined positions");
    }

    private JPanel createEditPositionPanel(WidgetFactory widgetFactory) {
        this.setPositionButton = widgetFactory.createButton((Action)((Object)new SetPositionAction()));
        this.setPositionButton.setName(SET_POSITION);
        this.moveHereButton = widgetFactory.createButton((Action)this.safeHomeMoveToAction);
        this.moveHereButton.setIcon(null);
        this.moveHereButton.setText(this.textResource.moveRobotHere());
        return this.viewContext.createFormBuilder().component((JComponent)this.setPositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().end().component((JComponent)this.moveHereButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW, FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().getCardPanel(LanguagePack.getCommandNamesResource().Home());
    }

    private JButton createMoveToButton(PoweredOnRobotRequirement poweredOnRobotRequirement, MoveToAction moveToAction) {
        moveToAction.setRobotStateRequirement(poweredOnRobotRequirement);
        moveToAction.setCardPanel((CardPanel)this);
        JButton moveToPositionButton = new JButton((Action)moveToAction);
        moveToPositionButton.setName((String)moveToAction.getValue("InternalName"));
        return moveToPositionButton;
    }

    private JPanel createJointPositionPanel() {
        this.joint1ValueLabel = new JLabel();
        this.joint2ValueLabel = new JLabel();
        this.joint3ValueLabel = new JLabel();
        this.joint4ValueLabel = new JLabel();
        this.joint5ValueLabel = new JLabel();
        this.joint6ValueLabel = new JLabel();
        this.addJComponentsToArrays();
        this.setLabelProperties();
        return this.viewContext.createFormBuilder().label(this.moveTextResource.joint0Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint1ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint1Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint2ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint2Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint3ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint3Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint4ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint4Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint5ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().label(this.moveTextResource.joint5Name(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).component((JComponent)this.joint6ValueLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().getCardPanel(this.moveTextResource.jointPosition());
    }

    private void updateComponents(SafeHomeSettings settings) {
        this.robotCanvas.setVisible(settings.isEnabled());
        this.setJointsValueLabels(settings.getPosition(), settings.isEnabled());
        this.setJoint3DPosition(settings.getPosition());
        this.moveHereButton.setEnabled(settings.isEnabled());
        this.updateSetPositionButton(settings.isEnabled());
    }

    private void updateSetPositionButton(boolean isPositionSet) {
        String buttonText = isPositionSet ? this.textResource.editPosition() : this.textResource.setPosition();
        this.setPositionButton.setText(buttonText);
    }

    private void setJoint3DPosition(JointPositionVector jpv) {
        this.visualizerFactory.showRobot(this.robotCanvas, jpv);
    }

    private void setJointsValueLabels(JointPositionVector jpv, boolean visible) {
        if (jpv != null) {
            int i = 0;
            while (i < this.jointValueLabels.length) {
                this.jointValueLabels[i].setText(degFormat.format(jpv.getJoint(i) * 57.29577951308232) + Units.getText().unitDegrees());
                this.jointValueLabels[i].setVisible(visible);
                ++i;
            }
        }
    }

    private void setLabelProperties() {
        JLabel[] jLabelArray = this.jointValueLabels;
        int n = this.jointValueLabels.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel jointValueLabel = jLabelArray[n2];
            jointValueLabel.setHorizontalAlignment(4);
            ++n2;
        }
    }

    private void addJComponentsToArrays() {
        this.jointValueLabels[0] = this.joint1ValueLabel;
        this.jointValueLabels[1] = this.joint2ValueLabel;
        this.jointValueLabels[2] = this.joint3ValueLabel;
        this.jointValueLabels[3] = this.joint4ValueLabel;
        this.jointValueLabels[4] = this.joint5ValueLabel;
        this.jointValueLabels[5] = this.joint6ValueLabel;
    }

    @Override
    protected void updateCard(SafeHomeSettings settings) {
        this.updateComponents(settings);
    }

    @Override
    public void enter(Object o) {
        this.robotCanvas.setVisible(((SafeHomeSettings)this.getInstallationComponent()).isEnabled());
        if (this.robotCanvas.isVisible()) {
            this.visualizerFactory.showRobot(this.robotCanvas, ((SafeHomeSettings)this.getInstallationComponent()).getPosition());
        }
        super.enter(o);
    }

    @Override
    public Object exit() {
        this.robotCanvas.setVisible(false);
        return super.exit();
    }

    Component getRobotCanvas() {
        return this.robotCanvas;
    }

    JLabel[] getJointValueLabels() {
        return this.jointValueLabels;
    }

    private class SetPositionAction
    extends AbstractActionDefinition {
        SetPositionAction() {
            this.putValue("Name", SafeHomeInstallationCardPanel.this.textResource.setPosition());
        }

        public void actionPerformed(ActionEvent e) {
            if (SafeHomeInstallationCardPanel.this.poweredOnRobotRequirement.checkAndNotify()) {
                SafeHomeInstallationCardPanel.this.robotCanvas.setVisible(false);
                SafeHomeInstallationCardPanel.this.positionRequester.requestPosition((CardPanel)SafeHomeInstallationCardPanel.this, new MoveCallback(){

                    public void onOk(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
                        SetPositionAction.this.setCustomHomePosition(jointPositionVector);
                        SafeHomeInstallationCardPanel.this.robotCanvas.setVisible(true);
                        SetPositionAction.this.notifyPositionHasChanged();
                    }

                    public void onCancel() {
                    }
                });
            }
        }

        private void setCustomHomePosition(JointPositionVector safeHomePosition) {
            SafeHomeSettings settings = (SafeHomeSettings)SafeHomeInstallationCardPanel.this.getInstallationComponent();
            settings.setPosition(safeHomePosition);
            settings.setEnabled(true);
            SafeHomeInstallationCardPanel.this.updateComponents(settings);
        }

        private void notifyPositionHasChanged() {
            SafeHomeInstallationCardPanel.this.eventManager.fireEvent(HomeOrSafeHomeChangedListener.class, HomeOrSafeHomeChangedListener::homeOrSafeHomeChanged);
        }
    }
}

