/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.security;

import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.security.SafetyLockPreAction;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SafetyLock {
    protected SafetyLockPreAction safetyLockPreAction;
    protected final List<SafetyLockListener> listeners = new ArrayList<SafetyLockListener>();
    protected boolean isLocked = true;

    @Inject
    public SafetyLock(SafetyLockPreAction safetyLockPreAction) {
        this.safetyLockPreAction = safetyLockPreAction;
    }

    public void lockSafety() {
        this.isLocked = true;
        this.safetyLockPreAction.onLock();
        for (SafetyLockListener each : this.listeners) {
            each.doLock();
        }
    }

    public void unlockSafety() {
        this.isLocked = false;
        this.safetyLockPreAction.onUnlock();
        for (SafetyLockListener each : this.listeners) {
            each.doUnlock();
        }
    }

    public void addSafetyLockListener(SafetyLockListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSafetyLockListener(SafetyLockListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isLocked() {
        return this.isLocked;
    }
}

