/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.security;

import com.ur.polyscope.security.PasswordManager;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.ViewContext;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public abstract class SafetyPasswordPanel
extends JPanel {
    private static final Dimension BUTTON_DIMENSIONS = new Dimension(95, 26);
    private static final Dimension INPUT_FIELD_DIMENSIONS = new Dimension(165, 26);
    public static final String UNLOCK = "unlock." + SafetyPasswordPanel.class.getSimpleName();
    public static final String LOCK = "lock." + SafetyPasswordPanel.class.getSimpleName();
    public static final String PASSWORD_FIELD = "field." + SafetyPasswordPanel.class.getSimpleName();
    public static final String SAFETY_PASSWORD_PANEL = "safetyPasswordPanel." + SafetyPasswordPanel.class.getSimpleName();
    protected final SafetyTextResource textResource;
    private final SafetyLock safetyLock;
    private final PasswordManager passwordManager;
    private final JLabel label;
    private final JPasswordField passwordField;
    private final JButton lockButton;
    private final JButton unLockButton;

    public SafetyPasswordPanel(PasswordManager passwordManager, SafetyLock lock, ViewContext viewContext) {
        this.passwordManager = passwordManager;
        this.safetyLock = lock;
        this.textResource = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.label = new JLabel(this.textResource.safetyPassword());
        this.unLockButton = this.createUnLockButton();
        this.passwordField = this.createPasswordField(this.unLockButton);
        this.lockButton = this.createLockButton();
        this.add(this.label);
        this.add(this.passwordField);
        this.add(this.unLockButton);
        this.add(this.lockButton);
        this.add(this.createSpacerLabel());
        this.addSafetyLockListener();
        this.setName(SAFETY_PASSWORD_PANEL);
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)this, "gui:installation_safety_locking");
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    protected abstract String getPasswordNotDefinedMessage();

    private void addSafetyLockListener() {
        this.safetyLock.addSafetyLockListener(new SafetyLockListener(){

            @Override
            public void doUnlock() {
                SafetyPasswordPanel.this.setUnlocked();
            }

            @Override
            public void doLock() {
                SafetyPasswordPanel.this.setLocked();
            }
        });
    }

    private JLabel createSpacerLabel() {
        JLabel spacerLabel = new JLabel("         ");
        int maxSpacingSize = 9;
        int maxWordSizeAtMaxSpacingSize = 15;
        int spaceCountToRemove = this.label.getText().length() - maxWordSizeAtMaxSpacingSize;
        if (spaceCountToRemove > 0) {
            int spacerTextLength = spaceCountToRemove > maxSpacingSize ? 1 : spaceCountToRemove;
            spacerLabel.setText(spacerLabel.getText().substring(0, spacerTextLength - 1));
        }
        return spacerLabel;
    }

    private JPasswordField createPasswordField(final JButton unLockButton) {
        final JPasswordField result = new JPasswordField();
        result.setPreferredSize(INPUT_FIELD_DIMENSIONS);
        result.setName(PASSWORD_FIELD);
        TextFieldUtils.bindEnterEventToButton((JTextField)result, (JButton)unLockButton);
        TextFieldUtils.bindTextPicker((JComponent)result, (TextHolder)new TextHolder(){

            public String getText() {
                return "";
            }

            public void setText(String text) {
                result.setText(text);
                unLockButton.doClick();
            }
        });
        result.getDocument().addDocumentListener((DocumentListener)new DocumentUpdateListener(){

            public void update() {
                if (!new String(result.getPassword()).isEmpty()) {
                    result.setBackground(Color.white);
                    DisplayMessageFactory.removeRegistration((JComponent)result);
                }
            }
        });
        return result;
    }

    private JButton createUnLockButton() {
        JButton result = new JButton();
        result.setText(this.textResource.unlock());
        result.setMaximumSize(BUTTON_DIMENSIONS);
        result.setMinimumSize(BUTTON_DIMENSIONS);
        result.setName(UNLOCK);
        result.addActionListener(evt -> this.unlockButtonAction());
        return result;
    }

    public final void unlockButtonAction() {
        if (this.isSafetyPasswordUndefined()) {
            DisplayMessageFactory.error((JComponent)this.passwordField, (String)this.getPasswordNotDefinedMessage());
            return;
        }
        if (this.isGivenSafetyPasswordCorrect()) {
            this.unlockAuthorized();
            return;
        }
        DisplayMessageFactory.error((JComponent)this.passwordField, (String)this.textResource.incorrectSafetyPassword());
    }

    protected void unlockAuthorized() {
        this.safetyLock.unlockSafety();
    }

    private boolean isSafetyPasswordUndefined() {
        return !this.passwordManager.isPasswordDefined(PasswordManager.Lock.SAFETY);
    }

    private boolean isGivenSafetyPasswordCorrect() {
        return this.passwordManager.verifyPassword(PasswordManager.Lock.SAFETY, new String(this.passwordField.getPassword()));
    }

    private JButton createLockButton() {
        JButton result = new JButton();
        result.setText(this.textResource.lock());
        result.setMaximumSize(BUTTON_DIMENSIONS);
        result.setMinimumSize(BUTTON_DIMENSIONS);
        result.setName(LOCK);
        result.setEnabled(false);
        result.addActionListener(evt -> this.lockButtonAction());
        return result;
    }

    protected void lockButtonAction() {
        this.safetyLock.lockSafety();
    }

    private void setLocked() {
        this.label.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.passwordField.setText("");
        this.unLockButton.setEnabled(true);
        this.lockButton.setEnabled(false);
    }

    private void setUnlocked() {
        this.label.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.passwordField.setText("");
        this.unLockButton.setEnabled(false);
        this.lockButton.setEnabled(true);
    }
}

