/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.security;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.security.AccessControlStateListener;
import com.ur.polyscope.security.OperationalModeSource;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.security.UserAccessState;
import com.ur.safety.SafetyChangeListener;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.OperationalMode;
import javax.inject.Inject;

public class SynchronizeOperationalModeWithController {
    private static final String SET_OPERATIONAL_MODE_COMMAND = "set operational mode ";
    private final ControllerInterface controllerInterface;

    @Inject
    public SynchronizeOperationalModeWithController(EventManager eventManager, ControllerInterface controllerInterface, final UserAccessControl userAccessControl) {
        this.controllerInterface = controllerInterface;
        eventManager.addStrongListener(AccessControlStateListener.class, (oldState, currentState) -> this.sendOperationalMode(currentState));
        eventManager.addStrongListener(SafetyChangeListener.class, (Object)new SafetyChangeListener.Template(){

            @Override
            public void safetyOnControllerConfirmed(SafetySetup setup) {
                SynchronizeOperationalModeWithController.this.sendOperationalMode(userAccessControl.getCurrentState());
            }
        });
    }

    void sendOperationalMode(UserAccessState state) {
        if (state.getOperationalModeSource().equals((Object)OperationalModeSource.NONE)) {
            this.sendCommand(OperationalMode.DISABLED);
        } else if (!EqualsUtil.equalsOneOf((Object)state.getOperationalModeSource(), (Object[])new OperationalModeSource[]{OperationalModeSource.SAFETY_IO, OperationalModeSource.SAFETY_UI, OperationalModeSource.SAFETY_PROFISAFE})) {
            this.sendCommand(state.getOperationalMode());
        }
    }

    private void sendCommand(OperationalMode mode) {
        this.controllerInterface.runScript(SET_OPERATIONAL_MODE_COMMAND + this.getCommandForOperationalMode(mode));
    }

    private String getCommandForOperationalMode(OperationalMode mode) {
        switch (mode) {
            case MANUAL: {
                return "programming";
            }
            case AUTOMATIC: {
                return "running";
            }
            case DISABLED: {
                return "disabled";
            }
        }
        throw new IllegalStateException("Unexpected Operational Mode");
    }
}

