/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.stream;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.PackageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.safety.stream.InternalData;
import com.ur.safety.stream.InternalDataModelSource;
import com.ur.view.constants.comm.RobotStatePackageType;
import com.ur.view.constants.dev.RobotMode;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InternalDataPackageConsumer
implements RobotStatePackageConsumer {
    private static final int SIZE_IN_BYTES = PackageConsumer.NumberOf.bytes((int)1);
    private static final RobotStatePackageType type = RobotStatePackageType.INTERNAL_DATA;
    private final InternalDataModelSource modelSource;

    @Inject
    public InternalDataPackageConsumer(InternalDataModelSource modelSource) {
        this.modelSource = modelSource;
    }

    public RobotStatePackageType getPackageType() {
        return type;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        RobotMode robotModeWithNewStates = RobotMode.byId((int)stream.readByte());
        this.modelSource.emit(new InternalData(robotModeWithNewStates));
        return SIZE_IN_BYTES;
    }

    public void initialize(RobotState robotStateToEditHere) {
    }
}

