/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.threepositionenabling.application;

import com.ur.lang.EqualsUtil;
import com.ur.lang.react.Broadcaster;
import com.ur.lang.react.Consumer;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.controllerinterface.RobotModeListener;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.safety.operationalmode.SafetyOperationalMode;
import com.ur.polyscope.viewfacade.safety.SafetyOperationalModeService;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.io.SafetyIOConfiguration;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.profisafe.ProfisafeConfiguration;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.TPType;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SafetyOperationalModeServiceImpl
extends SafetyChangeListener.Template
implements SafetyOperationalModeService {
    private final EventManager eventManager;
    protected final SafetySettingsLookupService safetyLookup;
    private final DisableIndicatorWhenDisconnectedFromController robotModeMonitor;
    private SafetyOperationalMode activeOperationalMode = SafetyOperationalMode.NONE;
    private boolean doMonitoring;
    private Subscription monitorSubscriptions;
    private final ControllerInterface controllerInterface;

    @Inject
    public SafetyOperationalModeServiceImpl(EventManager eventManager, SafetySettingsLookupService safetyLookup, @SafetyOperationalMode.Qualifier Broadcaster safetyOperationModeObserver, ControllerInterface controllerInterface) {
        this.eventManager = eventManager;
        this.safetyLookup = safetyLookup;
        this.controllerInterface = controllerInterface;
        safetyOperationModeObserver.distinctUntilChanged().subscribe((Consumer)new OperationalModeChangeMonitor());
        this.robotModeMonitor = new DisableIndicatorWhenDisconnectedFromController();
    }

    public boolean isUIDriven() {
        return this.isThreePositionDeviceEnabled() && !this.isIODriven() && !this.isProfiSafeDriven();
    }

    public boolean isIODriven() {
        SafetySetup safetySetup = this.safetyLookup.getSafetySetup();
        return this.isOperationalModeInputAssigned(safetySetup);
    }

    public boolean isThreePositionDeviceEnabled() {
        SafetySetup safetySetup = this.safetyLookup.getSafetySetup();
        return this.isThreePositionEnablingInputAssigned(safetySetup) || this.isTpWith3PEConfigured(safetySetup);
    }

    public boolean isProfiSafeDriven() {
        SafetySetup safetySetup = this.safetyLookup.getSafetySetup();
        return this.isProfisafeAndOperationalModeEnabled(safetySetup);
    }

    @Override
    public void safetyOnControllerConfirmed(SafetySetup setup) {
        this.adjustMonitoring(setup);
    }

    @Override
    public void safetyRequestedToBeApplied(SafetySetup setup) {
        this.doMonitoring = false;
        this.setActiveOperationalMode(SafetyOperationalMode.NONE);
    }

    private void adjustMonitoring(SafetySetup safetySetup) {
        if (this.operationalModeInputEnabled(safetySetup)) {
            this.doMonitoring = true;
            if (this.monitorSubscriptions == null) {
                this.monitorSubscriptions = this.eventManager.addStrongListener(RobotModeListener.class, (Object)this.robotModeMonitor);
            }
            if (this.isOperationalModeInputAssigned(safetySetup) || this.isProfisafeOperationalModeEnabled(safetySetup)) {
                this.setActiveOperationalMode(SafetyOperationalMode.AUTOMATIC);
            } else {
                this.setActiveOperationalMode(SafetyOperationalMode.MANUAL);
            }
        } else if (this.monitorSubscriptions != null) {
            this.doMonitoring = false;
            this.monitorSubscriptions.dispose();
            this.monitorSubscriptions = null;
            this.setActiveOperationalMode(SafetyOperationalMode.NONE);
        }
    }

    private boolean operationalModeInputEnabled(SafetySetup safetySetup) {
        return this.isThreePositionEnablingInputAssigned(safetySetup) || this.isOperationalModeInputAssigned(safetySetup) || this.isProfisafeAndOperationalModeEnabled(safetySetup);
    }

    private synchronized void setActiveOperationalMode(SafetyOperationalMode mode) {
        SafetyOperationalMode oldOperationalMode = this.activeOperationalMode;
        this.activeOperationalMode = mode;
        this.notifyOperationalModeChange(oldOperationalMode, this.activeOperationalMode);
    }

    private void notifyOperationalModeChange(SafetyOperationalMode oldOperationalMode, SafetyOperationalMode newOperationalMode) {
        this.eventManager.fireEvent(SafetyOperationalModeService.OperationalModeListener.class, listener -> listener.modeChanged(oldOperationalMode, newOperationalMode));
    }

    private boolean isThreePositionEnablingInputAssigned(SafetySetup safetySetup) {
        return safetySetup != null && ((SafetyIOConfiguration)safetySetup.getComponent(SafetyIOConfiguration.class)).getThreePositionEnablingInputs().isAssigned();
    }

    private boolean isOperationalModeInputAssigned(SafetySetup safetySetup) {
        return safetySetup != null && ((SafetyIOConfiguration)safetySetup.getComponent(SafetyIOConfiguration.class)).getOperationalModeInputs().isAssigned();
    }

    private boolean isTpWith3PEConfigured(SafetySetup safetySetup) {
        return safetySetup != null && ((SafetyMiscConfiguration)safetySetup.getComponent(SafetyMiscConfiguration.class)).getTeachPendant() == TPType.THREE_POSITION_ENABLING;
    }

    private boolean isProfisafeAndOperationalModeEnabled(SafetySetup safetySetup) {
        return this.isProfisafeEnabled(safetySetup) && this.isProfisafeOperationalModeEnabled(safetySetup);
    }

    private boolean isProfisafeEnabled(SafetySetup safetySetup) {
        return safetySetup != null && ((ProfisafeConfiguration)safetySetup.getComponent(ProfisafeConfiguration.class)).isEnabled();
    }

    private boolean isProfisafeOperationalModeEnabled(SafetySetup safetySetup) {
        return safetySetup != null && ((ProfisafeConfiguration)safetySetup.getComponent(ProfisafeConfiguration.class)).isOperationalModeEnabled();
    }

    public SafetyOperationalMode getSafetyOperationalMode() {
        return this.activeOperationalMode;
    }

    public void setSafetyOperationalMode(SafetyOperationalMode operationalMode) {
        this.sendSetOperationalMode(operationalMode);
    }

    private void sendSetOperationalMode(SafetyOperationalMode mode) {
        if (!EqualsUtil.equalsOneOf((Object)mode, (Object[])new SafetyOperationalMode[]{SafetyOperationalMode.AUTOMATIC, SafetyOperationalMode.MANUAL})) {
            return;
        }
        String command = "set operational mode ";
        command = mode == SafetyOperationalMode.AUTOMATIC ? String.valueOf(command) + "running" : String.valueOf(command) + "programming";
        this.controllerInterface.runScript(command);
    }

    private final class DisableIndicatorWhenDisconnectedFromController
    implements RobotModeListener {
        private DisableIndicatorWhenDisconnectedFromController() {
        }

        public void modeChanged(RobotMode oldValue, RobotMode newValue) {
            if (EqualsUtil.equalsOneOf((Object)newValue, (Object[])new RobotMode[]{RobotMode.NO_CONTROLLER, RobotMode.DISCONNECTED})) {
                SafetyOperationalModeServiceImpl.this.adjustMonitoring(null);
            }
        }
    }

    private class OperationalModeChangeMonitor
    implements Consumer<SafetyOperationalMode> {
        private OperationalModeChangeMonitor() {
        }

        public void accept(SafetyOperationalMode safetyOperationalMode) {
            if (SafetyOperationalModeServiceImpl.this.doMonitoring) {
                SafetyOperationalModeServiceImpl.this.setActiveOperationalMode(safetyOperationalMode);
            }
        }
    }
}

