/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.threepositionenabling.application;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.misc.core.SafetyMiscConfiguration;
import com.ur.safety.threepositionenabling.application.ThreePositionEnablingConfiguration;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.TPType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;

public class SyncThreePositionWithMiscSafety {
    private ThreePositionEnablingConfiguration threePositionEnablingConfiguration;
    private final UpdateUseTp3pe updateUseTp3pe;

    @Inject
    public SyncThreePositionWithMiscSafety(SafetySettingsLookupService provider, EventManager eventManager) {
        SafetyMiscConfiguration miscConfiguration = provider.getSafetyComponent(SafetyMiscConfiguration.class);
        this.threePositionEnablingConfiguration = provider.getSafetyComponent(ThreePositionEnablingConfiguration.class);
        this.updateUseTp3pe = new UpdateUseTp3pe();
        this.updateListener(miscConfiguration);
        eventManager.addStrongListener(SafetyChangeListener.class, (Object)new SafetyUpdatedListener());
    }

    private void updateListener(SafetyMiscConfiguration configuration) {
        configuration.removePropertyChangeListener(this.updateUseTp3pe);
        configuration.addPropertyChangeListener(this.updateUseTp3pe);
    }

    private class SafetyUpdatedListener
    extends SafetyChangeListener.Template {
        private SafetyUpdatedListener() {
        }

        @Override
        public void safetyLoaded(SafetySetup setup) {
            SyncThreePositionWithMiscSafety.this.threePositionEnablingConfiguration = (ThreePositionEnablingConfiguration)setup.getComponent(ThreePositionEnablingConfiguration.class);
            SyncThreePositionWithMiscSafety.this.updateListener((SafetyMiscConfiguration)setup.getComponent(SafetyMiscConfiguration.class));
        }
    }

    private class UpdateUseTp3pe
    implements PropertyChangeListener {
        private UpdateUseTp3pe() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("teach_pendant")) {
                SyncThreePositionWithMiscSafety.this.threePositionEnablingConfiguration.setUseTp3pe(evt.getNewValue() == TPType.THREE_POSITION_ENABLING);
            }
        }
    }
}

