/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.threepositionenabling.application;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.threepositionenabling.application.ThreePositionEnablingConfiguration;
import org.apache.commons.lang3.BooleanUtils;

public class ThreePositionEnablingContribution
implements SafetySetupContribution<ThreePositionEnablingConfiguration> {
    static final String THREE_POSITION_ENABLING_SECTION_NAME = "ThreePositionEnabling";
    static final String USE_TP_3PE = "useTP3PE";
    static final String USE_TP_3PE_OBFUSCATE = "safety001";
    static final String ALLOW_MANUAL_HIGH_SPEED = "allowManualHighSpeed";

    public Class<ThreePositionEnablingConfiguration> getComponentType() {
        return ThreePositionEnablingConfiguration.class;
    }

    public ThreePositionEnablingConfiguration createDefaultComponent() {
        return new ThreePositionEnablingConfiguration();
    }

    public ThreePositionEnablingConfiguration readFromOptions(ChecksumVersion version, Options options) {
        ThreePositionEnablingConfiguration component = this.createDefaultComponent();
        OptionsSection section = options.getSection(THREE_POSITION_ENABLING_SECTION_NAME);
        String useTP3PEKey = section.isSet(USE_TP_3PE_OBFUSCATE) ? USE_TP_3PE_OBFUSCATE : USE_TP_3PE;
        Integer useTP3PEValue = section.getInteger(useTP3PEKey, Integer.valueOf(BooleanUtils.toInteger((boolean)false)));
        component.setUseTp3pe(BooleanUtils.toBoolean((int)useTP3PEValue));
        Integer allowManualHighSpeedValue = section.getInteger(ALLOW_MANUAL_HIGH_SPEED, Integer.valueOf(BooleanUtils.toInteger((boolean)true)));
        component.setAllowManualHighSpeed(BooleanUtils.toBoolean((int)allowManualHighSpeedValue));
        return component;
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, ThreePositionEnablingConfiguration component) {
        this.copyToOptions(options, component);
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, ThreePositionEnablingConfiguration component) {
        this.copyToOptions(options, component);
    }

    public boolean isSupported(ChecksumVersion version) {
        return version.atLeast(ChecksumVersion.VERSION_5_3);
    }

    private void copyToOptions(Options options, ThreePositionEnablingConfiguration component) {
        OptionsSection section = options.getSection(THREE_POSITION_ENABLING_SECTION_NAME);
        section.setInteger(USE_TP_3PE, Integer.valueOf(BooleanUtils.toInteger((boolean)component.isUseTp3pe())));
        section.setInteger(ALLOW_MANUAL_HIGH_SPEED, Integer.valueOf(BooleanUtils.toInteger((boolean)component.isAllowManualHighSpeed())));
    }
}

