/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.threepositionenabling.client;

import com.ur.polyscope.safety.operationalmode.SafetyOperationalMode;
import com.ur.polyscope.viewfacade.safety.SafetyOperationalModeService;
import com.ur.safety.threepositionenabling.client.SafetyOperationalModeIndicatorImpl;
import java.awt.CardLayout;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OperationalModeListenerImpl
implements SafetyOperationalModeService.OperationalModeListener {
    private final WeakReference<JPanel> panelRef;
    private final JLabel label;
    private final CardLayout layout;

    OperationalModeListenerImpl(WeakReference<JPanel> panelRef, JLabel label, CardLayout layout) {
        this.panelRef = panelRef;
        this.label = label;
        this.layout = layout;
    }

    public void modeChanged(SafetyOperationalMode oldOperationalMode, SafetyOperationalMode newOperationalMode) {
        this.updateIndicator(newOperationalMode);
    }

    private void updateIndicator(SafetyOperationalMode operationalMode) {
        JPanel indicatorPanel = (JPanel)this.panelRef.get();
        if (indicatorPanel == null) {
            return;
        }
        switch (operationalMode) {
            case AUTOMATIC: {
                this.label.setIcon(SafetyOperationalModeIndicatorImpl.RUNNING_MODE_INDICATOR);
                this.layout.show(indicatorPanel, "INDICATOR_CARD");
                break;
            }
            case MANUAL: {
                this.label.setIcon(SafetyOperationalModeIndicatorImpl.PROGRAMMING_MODE_INDICATOR);
                this.layout.show(indicatorPanel, "INDICATOR_CARD");
                break;
            }
            default: {
                this.layout.show(indicatorPanel, "NO_INDICATOR_CARD");
            }
        }
    }
}

