/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.threepositionenabling.client;

import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.threepositionenabling.application.ThreePositionEnablingConfiguration;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.OnOffSwitch;
import com.ur.swing.ViewContext;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

@Singleton
public class ThreePositionEnablingPanel
extends ActivatablePanel
implements ReloadOnSafetyLoaded,
SafetyLockListener {
    private static final String MANUAL_HIGHSPEED_SWITCH = "highspeedSwitch." + ThreePositionEnablingPanel.class.getSimpleName();
    private final ViewContext viewContext;
    private final SafetySettingsLookupService provider;
    private OnOffSwitch allowManualHighSpeed;
    private final SafetyTextResource safetyTextResource;

    @Inject
    public ThreePositionEnablingPanel(ViewContext viewContext, SafetySettingsLookupService provider, SafetyLock safetyLock, SafetyTextResource safetyTextResource) {
        this.viewContext = viewContext;
        this.provider = provider;
        this.safetyTextResource = safetyTextResource;
        safetyLock.addSafetyLockListener(this);
        this.initComponents();
        this.update();
        this.setLocked(safetyLock.isLocked());
    }

    private void initComponents() {
        this.allowManualHighSpeed = new OnOffSwitch(this.safetyTextResource.threePositionManualHighSpeedToggle());
        this.allowManualHighSpeed.setName(MANUAL_HIGHSPEED_SWITCH);
        this.allowManualHighSpeed.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.allowManualHighSpeed.addActionListener(actionEvent -> this.getConfiguration().setAllowManualHighSpeed(((JCheckBox)actionEvent.getSource()).isSelected()));
        FormBuilder formBuilder = this.viewContext.createFormBuilder().label(ViewImageResource.formInformation(), this.safetyTextResource.threePositionHighSpeedsInfo(), new FormBuilder.PanelConstraints[0]).end().end();
        formBuilder.buttonRow((JComponent)this.allowManualHighSpeed, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN}).end();
        JPanel three3PEPanel = formBuilder.getCardPanel(this.safetyTextResource.threePositionPanelHeader());
        this.setLayout(new BoxLayout(this, 2));
        this.setAlignmentX(0.0f);
        this.add(three3PEPanel);
    }

    JCheckBox getAllowManualHighSpeed() {
        return this.allowManualHighSpeed;
    }

    private ThreePositionEnablingConfiguration getConfiguration() {
        return this.provider.getSafetyComponent(ThreePositionEnablingConfiguration.class);
    }

    private void update() {
        ThreePositionEnablingConfiguration configuration = this.getConfiguration();
        this.allowManualHighSpeed.setSelected(configuration.isAllowManualHighSpeed());
    }

    @Override
    public void activate() {
        this.update();
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void reset() {
        this.update();
    }

    private void setLocked(boolean locked) {
        this.allowManualHighSpeed.setEnabled(!locked);
    }

    @Override
    public void doUnlock() {
        this.setLocked(false);
    }

    @Override
    public void doLock() {
        this.setLocked(true);
    }
}

