/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.tolerances;

import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import java.io.DataInput;
import java.io.IOException;

public class SafetyComplianceToleranceMessage {
    private static void convertJointPositionDataFromController(double[] jointPositionsGui, double[] jointPositionsController, int[] jointRevolutionsController) {
        int i = 0;
        while (i < jointPositionsController.length) {
            jointPositionsGui[i] = (double)jointRevolutionsController[i] * (Math.PI * 2) + jointPositionsController[i];
            ++i;
        }
    }

    public static int parseMessage(SafetyComplianceTolerances st, DataInput ds) throws IOException {
        int messageOffset = 0;
        st.setSpeedTolerance(ds.readDouble());
        st.setForceTolerance(ds.readDouble());
        st.setPowerTolerance(ds.readDouble());
        st.setMomentumTolerance(ds.readDouble());
        messageOffset += 32;
        double[] jointSpeed = new double[6];
        SafetyComplianceToleranceMessage.parseDoubleArray(ds, jointSpeed);
        st.setJointSpeedTolerance(jointSpeed);
        messageOffset += 48;
        double[] jointPositionsController = new double[6];
        int[] jointRevolutionsController = new int[6];
        SafetyComplianceToleranceMessage.parseDoubleArray(ds, jointPositionsController);
        SafetyComplianceToleranceMessage.parseIntArray(ds, jointRevolutionsController);
        double[] jointPosition = JointConfigurationSettings.JOINT_POSITION_DEFAULT;
        SafetyComplianceToleranceMessage.convertJointPositionDataFromController(jointPosition, jointPositionsController, jointRevolutionsController);
        st.setJointPositionTolerance(jointPosition);
        messageOffset += 72;
        st.setToolOrientationTolerance(ds.readDouble());
        st.setToolPositionTolerance(ds.readDouble());
        st.setTriggerToolPositionTolerance(ds.readDouble());
        return messageOffset += 24;
    }

    private static void parseIntArray(DataInput ds, int[] intArrayJoint) throws IOException {
        int i = 0;
        while (i < 6) {
            intArrayJoint[i] = ds.readInt();
            ++i;
        }
    }

    private static void parseDoubleArray(DataInput ds, double[] doubleArrayJoint) throws IOException {
        int i = 0;
        while (i < 6) {
            doubleArrayJoint[i] = ds.readDouble();
            ++i;
        }
    }
}

