/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.tolerances;

import com.ur.monitor.RobotState;
import com.ur.move.ControllerSocketSender;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.util.event.EventManager;
import javax.inject.Inject;

public class SetControllerStateOnSafetyTolerancesReceived
extends SafetyChangeListener.Template {
    private final RobotInstallationSite lookupService;
    private ControllerInterface controllerInterface;

    @Inject
    public SetControllerStateOnSafetyTolerancesReceived(EventManager event, RobotInstallationSite lookupService, ControllerInterface controllerInterface) {
        this.lookupService = lookupService;
        this.controllerInterface = controllerInterface;
        event.addStrongListener(SafetyChangeListener.class, (Object)this);
    }

    @Override
    public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
        ((IOService)this.lookupService.getInstallation().getComponent(IOService.class)).resetOutputActions();
        this.pauseProgramIfRunning();
        ControllerSocketSender.setRealRobotBlocking();
        ScriptWriter writer = new ScriptWriter();
        writer.defineSecondary("set_controller_state");
        this.lookupService.getInstallation().generatePreambleScript(writer);
        writer.end();
        this.controllerInterface.runScript(writer.generateScript());
    }

    private void pauseProgramIfRunning() {
        if (RobotState.getLatestRobotState().programRunning) {
            this.controllerInterface.runScript("pause program\n");
        }
    }
}

