/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.toolorientation.domain;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.StringUtils;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetySetupToHtmlContribution;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.toolorientation.externalapi.SphericalAngleCoordinates;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.safety.workpiece.core.ToolOrientation;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.swing.HTML;
import java.text.DecimalFormat;
import javax.inject.Inject;

public class ToolOrientationToHtmlRenderer
implements SafetySetupToHtmlContribution {
    private final SafetyTextResource text;
    private final SafetySetupPanesLookAndFeel lookAndFeel;

    @Inject
    public ToolOrientationToHtmlRenderer(SafetyTextResource text, SafetySetupPanesLookAndFeel lookAndFeel) {
        this.text = text;
        this.lookAndFeel = lookAndFeel;
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        String pageContent = this.renderPageContent(safetySetup, useSIUnits);
        return new HTMLPage(this.text.safetyTabToolDirection(), pageContent);
    }

    private String renderPageContent(SafetySetup safetySetup, boolean useSIUnits) {
        ToolOrientationLimit limit = ((SafetyBoundaries)safetySetup.getComponent(SafetyBoundaries.class)).getToolOrientationLimit();
        if (limit.getSafetyMode() == SafetyLimitMode.DISABLED) {
            return HTML.html((String)HTML.h2((String)this.text.NoToolDirectionLimitDefined()));
        }
        Vector3 optimalDirection = limit.getTCPOrientationVector();
        StringBuilder result = new StringBuilder();
        UnitsConverter angleConverter = useSIUnits ? Units.getRadiansConverter() : Units.getDegreesConverter();
        result.append(HTML.center((String)HTML.h2((String)this.text.limitProperties())));
        DecimalFormat formatter = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#0.####");
        AlternatingBackgroundRowGenerator rowGenerator = new AlternatingBackgroundRowGenerator();
        String alignCenter = "align=center";
        result.append(HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.text.Property()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.text.Value()), HTML.tableHeaderWithProperties((String)alignCenter, (String)this.text.Clarification())}), rowGenerator.generate(HTML.tableCell((String)this.text.Direction()), HTML.tableCellWithProperties((String)alignCenter, (String)("[" + StringUtils.joinStringsWith((String)",&nbsp;", (Object[])new String[]{formatter.format(optimalDirection.x()), formatter.format(optimalDirection.y()), formatter.format(optimalDirection.z())}) + "]")), HTML.tableCell((String)""), HTML.tableCell((String)HTML.italic((String)this.text.vectorInBaseCoordinates()))), rowGenerator.generate(HTML.tableCell((String)this.text.safetyHeaderDeviation()), HTML.tableCellWithProperties((String)alignCenter, (String)(String.valueOf(formatter.format(angleConverter.convertFrom(limit.getMaximumTcpOrientationDeviation()))) + " " + angleConverter.getUnit())), HTML.tableCell((String)""), HTML.tableCell((String)HTML.italic((String)this.text.deviationClarification()))), rowGenerator.generate(HTML.tableCell((String)this.text.safetyHeaderRestrictions()), HTML.tableCellWithProperties((String)alignCenter, (String)this.text.safetyLimitMode(limit.getSafetyMode())), HTML.tableCell((String)""), HTML.tableCell((String)HTML.italic((String)this.text.restrictionsClarification())))}));
        result.append(HTML.br());
        result.append(HTML.center((String)HTML.h2((String)this.text.toolProperties())));
        ToolOrientation tool = ((WorkpieceConfiguration)safetySetup.getComponent(WorkpieceConfiguration.class)).getToolOrientation();
        rowGenerator = new AlternatingBackgroundRowGenerator();
        result.append(HTML.table((int)this.lookAndFeel.panelWidth, (String[])new String[]{HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.text.Property()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.text.Value()), HTML.tableHeaderWithProperties((String)"align=center", (String)this.text.Clarification())}), rowGenerator.generate(HTML.tableCell((String)this.text.sphericalAngleLabel(SphericalAngleCoordinates.INCLINATION)), HTML.tableCellWithProperties((String)"align=right", (String)formatter.format(angleConverter.convertFrom(tool.sphericalDirection.inclination.asDouble()))), HTML.tableCell((String)angleConverter.getUnit()), HTML.tableCell((String)HTML.italic((String)this.text.inclinationClarification()))), rowGenerator.generate(HTML.tableCell((String)this.text.sphericalAngleLabel(SphericalAngleCoordinates.AZIMUTH)), HTML.tableCellWithProperties((String)"align=right", (String)formatter.format(angleConverter.convertFrom(tool.sphericalDirection.azimuth.asDouble()))), HTML.tableCell((String)angleConverter.getUnit()), HTML.tableCell((String)HTML.italic((String)this.text.azimuthClarification())))}));
        return result.toString();
    }
}

