/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.toolorientation.externalapi;

import com.ur.lang.DecimalFormatFactory;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.tolerances.SafetyComplianceTolerances;
import com.ur.safety.toolorientation.externalapi.SphericalAngleCoordinates;
import com.ur.safety.toolorientation.externalapi.ToolOrientationBinder;
import com.ur.safety.util.externalapi.CoordinateInputs;
import com.ur.safety.util.externalapi.ValidationStrategyProxy;
import com.ur.swing.InputView;
import com.ur.swing.number.Mode;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventManager;
import java.text.Format;
import javax.inject.Inject;

public class ToolOrientationInputBinderImpl
extends SafetyChangeListener.Template
implements ToolOrientationBinder {
    private final EventManager eventManager;
    private final SafetyTextResource text;
    private SafetyComplianceTolerances tolerances;

    @Inject
    public ToolOrientationInputBinderImpl(EventManager eventManager, SafetyTextResource safetyTextResource) {
        this.eventManager = eventManager;
        this.text = safetyTextResource;
        eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
    }

    @Override
    public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
        this.tolerances = tolerances;
    }

    @Override
    public void bindToolOrientationDeviationSupport(InputView inputView) {
        ToolDeviationValidationStrategyProxy validator = new ToolDeviationValidationStrategyProxy(inputView, this.text);
        this.setTolerances(inputView, validator);
    }

    private void setTolerances(InputView inputView, SafetyChangeListener listener) {
        if (this.tolerances == null) {
            this.eventManager.addWeakListener((Object)inputView, SafetyChangeListener.class, (Object)listener);
        } else {
            listener.safetyTolerancesReceived(this.tolerances);
        }
    }

    @Override
    public int getLabelWidth() {
        return 100;
    }

    @Override
    public int getUnitWidth() {
        return 190 - this.getLabelWidth();
    }

    @Override
    public String getLabelText(SphericalAngleCoordinates key) {
        return this.text.sphericalAngleLabel(key);
    }

    @Override
    public void bindCoordinates(CoordinateInputs<SphericalAngleCoordinates> coordinateInputs) {
        UnitsConverter converter = Units.getDegreesConverter();
        ValidationStrategyProxy errorStrategy = new ValidationStrategyProxy();
        errorStrategy.setValidaStrategy(ValidationFactory.getRangeValidator((double)(-Math.toRadians(360.0)), (double)Math.toRadians(360.0), (UnitsConverter)converter));
        SphericalAngleCoordinates[] sphericalAngleCoordinatesArray = SphericalAngleCoordinates.values();
        int n = sphericalAngleCoordinatesArray.length;
        int n2 = 0;
        while (n2 < n) {
            SphericalAngleCoordinates each = sphericalAngleCoordinatesArray[n2];
            InputView inputView = coordinateInputs.getInput(each);
            inputView.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.#"));
            inputView.setErrorValidationStrategy(new ValidationStrategy[]{errorStrategy});
            inputView.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)1)});
            inputView.setUnit(converter.getUnit());
            String limits = this.text.minimumAndMaximumValues(-360.0, 360.0, converter.getUnit());
            inputView.setRestrictionsText(limits);
            ++n2;
        }
    }

    private static class ToolDeviationValidationStrategyProxy
    extends SafetyChangeListener.Template {
        private final UnitsConverter deviationConverter = Units.getDegreesConverter();
        private final InputView inputView;
        private final SafetyTextResource text;
        private final ValidationStrategyProxy errorStrategy = new ValidationStrategyProxy();

        ToolDeviationValidationStrategyProxy(InputView inputView, SafetyTextResource text) {
            this.inputView = inputView;
            this.text = text;
            inputView.setMode(Mode.PositiveNumbers);
            inputView.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.#"));
            inputView.setErrorValidationStrategy(new ValidationStrategy[]{this.errorStrategy});
            inputView.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)1)});
        }

        @Override
        public void safetyTolerancesReceived(SafetyComplianceTolerances tolerances) {
            double minimumToolOrientation = Math.max(ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MINIMUM, tolerances.getToolOrientationTolerance());
            ValidationStrategy validator = ValidationFactory.getRangeValidator((double)minimumToolOrientation, (double)ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MAXIMUM, (UnitsConverter)this.deviationConverter);
            long minOrientation = (long)Math.toDegrees(minimumToolOrientation);
            long maxOrientation = (long)Math.toDegrees(ToolOrientationLimit.TOOL_ORIENTATION_DEVIATION_MAXIMUM);
            long orientationTolerance = (long)Math.toDegrees(tolerances.getToolOrientationTolerance());
            String limits = this.text.minimumAndMaximumValues(minOrientation, maxOrientation, this.deviationConverter.getUnit());
            this.inputView.setRestrictionsText(limits);
            this.errorStrategy.setValidaStrategy(validator);
            this.inputView.setUnit(" " + this.text.minimumAndMaximumValue(minOrientation, maxOrientation, ", ") + this.text.minusToleranceOneDecimal(orientationTolerance, this.deviationConverter.getUnit()));
        }
    }
}

