/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.toolorientation.externalapi;

import com.ur.lang.PrimitiveUtils;
import com.ur.math.Angle;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.HasUUID;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.core.ToolOrientationLimit;
import com.ur.safety.boundaries.externalapi.ElementDefinitionState;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.toolorientation.externalapi.SphericalAngleCoordinates;
import com.ur.safety.toolorientation.externalapi.ToolOrientationView;
import com.ur.safety.toolorientation.externalapi.ToolOrientationVisualization;
import com.ur.safety.util.domain.SpatialFeatureUniqueByName;
import com.ur.safety.util.externalapi.CoordinateValues;
import com.ur.safety.util.externalapi.DefinedPointsAndPlanes;
import com.ur.safety.util.externalapi.SelectFeaturePresenter;
import com.ur.safety.util.externalapi.SelectSafetyLimitPresenter;
import com.ur.safety.util.externalapi.SelectTCPPresenter;
import com.ur.safety.util.externalapi.SetCoordinatesPresenter;
import com.ur.safety.util.externalapi.SetDeviationPresenter;
import com.ur.safety.util.infrastructure.SelectTCP;
import com.ur.safety.workpiece.core.SphericalUnitVector;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.util.Conjunction;
import com.ur.util.Predicate;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ToolOrientationPresenter
implements ReloadOnSafetyLoaded,
SelectFeaturePresenter,
SetDeviationPresenter,
SelectSafetyLimitPresenter,
SelectTCPPresenter,
SetCoordinatesPresenter<SphericalAngleCoordinates> {
    private final FeaturesLookup featuresLookup;
    private final SafetySettingsLookupService safetyLookup;
    private final EnableToolOrientationView enableView;
    private final InstallationComponentLookup installationLookup;
    private ToolOrientationView view;
    private ToolOrientationVisualization toolOrientationVisualization;
    private UIToolOrientation uiToolOrientation = null;

    @Inject
    public ToolOrientationPresenter(FeaturesLookup featuresLookup, SafetySettingsLookupService safetyLookup, EnableToolOrientationView enableView, InstallationComponentLookup installationLookup) {
        this.featuresLookup = featuresLookup;
        this.safetyLookup = safetyLookup;
        this.enableView = enableView;
        this.installationLookup = installationLookup;
    }

    public void setView(ToolOrientationView view) {
        this.view = view;
        this.enableView.setView(view);
        this.activate();
    }

    public void set3DView(ToolOrientationVisualization toolOrientationVisualization) {
        this.toolOrientationVisualization = toolOrientationVisualization;
    }

    @Override
    public void reset() {
        this.createNewUiToolOrientation();
        this.updatePropertiesInView();
    }

    public void activate() {
        if (this.uiToolOrientation == null) {
            this.createNewUiToolOrientation();
        }
        this.view.setAvailableFeatures(this.featuresLookup.getFeaturesBy((Predicate)new Conjunction(new Predicate[]{new DefinedPointsAndPlanes(), new SpatialFeatureUniqueByName()})));
        this.enableView.setSelectedSafetyPlane(this.uiToolOrientation);
        TCPSettings settings = (TCPSettings)this.installationLookup.getComponent(TCPSettings.class);
        this.view.setTCPList(settings.getAllTCPs());
        this.updatePropertiesInView();
    }

    private void createNewUiToolOrientation() {
        this.uiToolOrientation = new UIToolOrientation(this.safetyLookup.getSafetyComponent(SafetyBoundaries.class).getToolOrientationLimit(), this.safetyLookup.getSafetyComponent(WorkpieceConfiguration.class), (TCPSettings)this.installationLookup.getComponent(TCPSettings.class));
    }

    public void deactivate() {
    }

    @Override
    public void selectFeature(SpatialFeature feature) {
        this.uiToolOrientation.setFeature((GeomFeature)feature);
        this.updatePropertiesInView();
    }

    @Override
    public void synchronizeFeature() {
        GeomFeature feature;
        if (this.uiToolOrientation.getFeatureId() != null && (feature = this.featuresLookup.getFeatureByUUID(this.uiToolOrientation.getFeatureId())) != null) {
            this.uiToolOrientation.setFeature(feature);
            this.updatePropertiesInView();
        }
    }

    @Override
    public void setSafetyLimitMode(SafetyLimitMode safetyLimitMode) {
        this.uiToolOrientation.setSafetyLimitMode(safetyLimitMode);
        this.updatePropertiesInView();
    }

    @Override
    public void setDeviation(String deviation) {
        this.uiToolOrientation.setDeviation(PrimitiveUtils.parseDouble((String)deviation, (double)this.uiToolOrientation.getDeviation()));
        this.updatePropertiesInView();
    }

    private void updatePropertiesInView() {
        GeomFeature feature = this.featuresLookup.getFeatureByUUID(this.uiToolOrientation.getFeatureId());
        this.view.setLimitProperties(feature, this.uiToolOrientation.getSafetyLimitMode(), this.uiToolOrientation.getDeviation());
        if (this.toolOrientationVisualization != null) {
            this.toolOrientationVisualization.updateToolOrientation(this.uiToolOrientation);
        }
        this.view.setSelectedFeatureState(this.uiToolOrientation.getDefinitionState(feature));
        this.view.setCoordinates((SphericalAngleCoordinates key) -> {
            switch (key) {
                case INCLINATION: {
                    return this.uiToolOrientation.getToolDirection().inclination.getIn(Angle.Unit.DEGREES);
                }
                case AZIMUTH: {
                    return this.uiToolOrientation.getToolDirection().azimuth.getIn(Angle.Unit.DEGREES);
                }
            }
            throw new IllegalArgumentException("Unknown SphericalAngleCoordinate constant");
        });
        if (this.uiToolOrientation.getTCP() == null) {
            this.view.selectTCP(this.uiToolOrientation.getDefinition());
        } else {
            this.view.selectTCP(this.uiToolOrientation.getTCP());
        }
        this.enableView.updateEnablement();
    }

    @Override
    public void setCoordinates(CoordinateValues<SphericalAngleCoordinates> value) {
        this.uiToolOrientation.setToolDirection(Angle.from((double)value.getValue(SphericalAngleCoordinates.INCLINATION), (Angle.Unit)Angle.Unit.DEGREES), Angle.from((double)value.getValue(SphericalAngleCoordinates.AZIMUTH), (Angle.Unit)Angle.Unit.DEGREES));
        this.updatePropertiesInView();
    }

    @Override
    public void selectTCP(TCP tcp) {
        this.uiToolOrientation.setTCP(tcp);
        this.updatePropertiesInView();
    }

    @Override
    public void selectDefaultTCP() {
        this.uiToolOrientation.setDefaultTCP();
        this.updatePropertiesInView();
    }

    @Override
    public void synchronizeTCP() {
        this.selectTCP(this.uiToolOrientation.getTCP());
        this.updatePropertiesInView();
    }

    static class EnableToolOrientationView
    implements SafetyLockListener {
        private final SafetyLock safetyLock;
        private final FeaturesLookup featuresLookup;
        private UIToolOrientation uiToolOrientation;
        private ToolOrientationView view;

        @Inject
        EnableToolOrientationView(SafetyLock safetyLock, FeaturesLookup featuresLookup) {
            this.safetyLock = safetyLock;
            this.featuresLookup = featuresLookup;
            safetyLock.addSafetyLockListener(this);
        }

        public void setView(ToolOrientationView view) {
            this.view = view;
        }

        public void setSelectedSafetyPlane(UIToolOrientation uiToolOrientation) {
            this.uiToolOrientation = uiToolOrientation;
        }

        @Override
        public void doUnlock() {
            this.updateEnablement();
        }

        @Override
        public void doLock() {
            this.updateEnablement();
        }

        private void updateEnablement() {
            boolean enableSelectFeature = !this.safetyLock.isLocked() && this.uiToolOrientation != null;
            this.view.setEnabledSelectFeature(enableSelectFeature);
            GeomFeature feature = this.featuresLookup.getFeatureByUUID(this.uiToolOrientation.getFeatureId());
            boolean enableSyncFeature = enableSelectFeature && this.uiToolOrientation.getDefinitionState(feature) == ElementDefinitionState.CHANGED;
            this.view.setEnabledSynchronizeFeature(enableSyncFeature);
            boolean enableOtherLimitProperties = enableSelectFeature && this.uiToolOrientation.getFeatureId() != null;
            this.view.setEnabledSelectSafetyMode(enableOtherLimitProperties);
            this.view.setEnabledChangeDeviation(enableOtherLimitProperties);
            this.view.setEnabledSelectTCP(enableOtherLimitProperties);
            this.view.setEnabledSetCoordinates(enableOtherLimitProperties);
            this.view.setTCPSynchronizationPossible(this.uiToolOrientation.isOutOfSyncWithTCP());
        }
    }

    public static class UIToolOrientation {
        private final UnitsConverter convertDeviation = Units.getDegreesConverter();
        private final ToolOrientationLimit toolOrientationLimit;
        private final WorkpieceConfiguration workpieceConfiguration;
        private final TCPSettings tcpSettings;

        UIToolOrientation(ToolOrientationLimit toolOrientationLimit, WorkpieceConfiguration workpieceConfiguration, TCPSettings tcpSettings) {
            this.toolOrientationLimit = toolOrientationLimit;
            this.workpieceConfiguration = workpieceConfiguration;
            this.tcpSettings = tcpSettings;
        }

        public void setFeature(GeomFeature geomFeature) {
            if (geomFeature == null) {
                this.setSafetyLimitMode(SafetyLimitMode.DISABLED);
                this.setDeviation(0.0);
            } else if (this.toolOrientationLimit.getSourceFeatureId() == null) {
                this.setSafetyLimitMode(SafetyLimitMode.BOTH);
            }
            this.toolOrientationLimit.copyFromGeomFeature(geomFeature);
        }

        public double getDeviation() {
            return this.convertDeviation.convertFrom(this.toolOrientationLimit.getMaximumTcpOrientationDeviation());
        }

        public void setDeviation(double deviation) {
            deviation = this.convertDeviation.convertTo(deviation);
            this.toolOrientationLimit.setMaximumTcpOrientationDeviation(deviation);
        }

        public UUID getFeatureId() {
            return this.toolOrientationLimit.getSourceFeatureId();
        }

        public SafetyLimitMode getSafetyLimitMode() {
            return this.toolOrientationLimit.getSafetyMode();
        }

        public void setSafetyLimitMode(SafetyLimitMode safetyLimitMode) {
            this.toolOrientationLimit.setSafetyMode(safetyLimitMode);
        }

        public ElementDefinitionState getDefinitionState(GeomFeature feature) {
            return ElementDefinitionState.getState(this.toolOrientationLimit, feature);
        }

        public boolean isDefined() {
            return !this.toolOrientationLimit.isUndefined();
        }

        public ToolOrientationLimit asToolOrientationLimit() {
            return this.toolOrientationLimit;
        }

        public SphericalUnitVector getToolDirection() {
            return this.workpieceConfiguration.getToolOrientation().sphericalDirection;
        }

        public void setToolDirection(Angle inclination, Angle azimuth) {
            this.workpieceConfiguration.updateToolOrientation(null, inclination, azimuth);
        }

        public void setDefaultTCP() {
            this.workpieceConfiguration.updateToolOrientation(null, SphericalUnitVector.Z_AXIS);
        }

        public TCP getTCP() {
            return this.tcpSettings.getTCPByUUID(this.workpieceConfiguration.getToolOrientation().sourceTCPId);
        }

        public void setTCP(TCP tcp) {
            this.workpieceConfiguration.updateToolOrientation(((HasUUID)tcp).getId(), this.calculateToolDirection(tcp));
        }

        public SelectTCP.Definition getDefinition() {
            TCP tcp = this.getTCP();
            if (tcp == null) {
                return SphericalUnitVector.Z_AXIS.isEquivalentTo(this.getToolDirection()) ? SelectTCP.Definition.ORIGIN : SelectTCP.Definition.CUSTOM;
            }
            SphericalUnitVector sphericalUnitVector = this.calculateToolDirection(tcp);
            if (sphericalUnitVector.isEquivalentTo(this.getToolDirection())) {
                return SelectTCP.Definition.FROM_TCP;
            }
            return SelectTCP.Definition.CUSTOM;
        }

        public boolean isOutOfSyncWithTCP() {
            return this.getTCP() != null && !this.getToolDirection().isEquivalentTo(this.calculateToolDirection(this.getTCP()));
        }

        private SphericalUnitVector calculateToolDirection(TCP tcp) {
            Vector3 rotatedZAxis = URMath.rotate((Vector3)Vector3.Z_AXIS, (Vector3)new Pose6d(tcp.getOffsetPose().asArray()).getRotation());
            return SphericalUnitVector.fromDirection(rotatedZAxis);
        }
    }
}

