/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.toolorientation.framework;

import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.safety.SafetyLimitMode;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.boundaries.externalapi.ElementDefinitionState;
import com.ur.safety.boundaries.infrastructure.Boundaries3DViewPanel;
import com.ur.safety.boundaries.infrastructure.BoundariesPanelImpl;
import com.ur.safety.toolorientation.externalapi.SphericalAngleCoordinates;
import com.ur.safety.toolorientation.externalapi.ToolOrientationBinder;
import com.ur.safety.toolorientation.externalapi.ToolOrientationPresenter;
import com.ur.safety.toolorientation.externalapi.ToolOrientationView;
import com.ur.safety.util.externalapi.CoordinateValues;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.safety.util.infrastructure.SelectFeature;
import com.ur.safety.util.infrastructure.SelectSafetyLimit;
import com.ur.safety.util.infrastructure.SelectTCP;
import com.ur.safety.util.infrastructure.SetCoordinates;
import com.ur.safety.util.infrastructure.SetDeviation;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ToolOrientationPanel
extends ActivatablePanel
implements ToolOrientationView {
    private final ToolOrientationPresenter presenter;
    private final ToolOrientationBinder binder;
    private final ViewContext viewContext;
    private final SafetyTextResource text;
    private final Boundaries3DViewPanel view3DPanel;
    private SelectFeature toolFeatures;
    private SelectSafetyLimit toolSafetyMode;
    private SetDeviation deviation;
    private SelectTCP tcpSelection;
    private SetCoordinates<SphericalAngleCoordinates> orientationOffsetCoordinates;
    private final HelpIdAssigner helpIdAssigner;
    private final RenderingStrategy strategy;
    private FeaturesLookup featuresLookup;

    @Inject
    public ToolOrientationPanel(ToolOrientationPresenter presenter, ToolOrientationBinder binder, ViewContext viewContext, Boundaries3DViewPanel view3DPanel, HelpIdAssigner helpIdAssigner, @Named(value="tcp-renderer") @Named(value="tcp-renderer") RenderingStrategy strategy, FeaturesLookup featuresLookup) {
        this.presenter = presenter;
        this.binder = binder;
        this.viewContext = viewContext;
        this.text = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.view3DPanel = view3DPanel;
        this.helpIdAssigner = helpIdAssigner;
        this.strategy = strategy;
        this.featuresLookup = featuresLookup;
        this.initComponents(viewContext);
        presenter.setView(this);
    }

    @Override
    public void activate() {
        if (Settings.isRunningInDevelopmentMode()) {
            this.removeAll();
            this.initComponents(this.viewContext);
        }
        this.view3DPanel.setActive(true);
        this.presenter.set3DView(this.view3DPanel);
        this.presenter.activate();
    }

    @Override
    public void deactivate() {
        this.view3DPanel.setActive(false);
        this.presenter.deactivate();
    }

    private void initComponents(ViewContext viewContext) {
        this.setBackground(BoundariesPanelImpl.BETWEEN_CARD_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(5, 5));
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.deviation = new SetDeviation(this.presenter, this.binder);
        this.toolFeatures = new SelectFeature(this.presenter, widgetFactory, this.text);
        this.toolSafetyMode = new SelectSafetyLimit(this.presenter, widgetFactory, SafetyLimitMode.valuesForTool());
        JPanel limitProperties = viewContext.createFormBuilder().components((FormBuilder.Components)this.toolFeatures, new FormBuilder.PanelConstraints[0]).label(this.text.safetyHeaderRestrictions(), new FormBuilder.PanelConstraints[0]).end().components((FormBuilder.Components)this.toolSafetyMode, new FormBuilder.PanelConstraints[0]).label(this.text.safetyHeaderDeviation(), new FormBuilder.PanelConstraints[0]).end().components((FormBuilder.Components)this.deviation, new FormBuilder.PanelConstraints[0]).getPanel();
        limitProperties.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.tcpSelection = new SelectTCP(this.presenter, viewContext, this.strategy);
        this.orientationOffsetCoordinates = new SetCoordinates<SphericalAngleCoordinates>(SphericalAngleCoordinates.class, this.presenter, this.binder, widgetFactory);
        JPanel offsetProperties = viewContext.createFormBuilder().components((FormBuilder.Components)this.tcpSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).label(this.text.editOrientation(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().components(this.orientationOffsetCoordinates, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).getPanel();
        JPanel rightSideView = new JPanel(new BorderLayout(0, 5));
        rightSideView.setMinimumSize(new Dimension(320, -1));
        rightSideView.setPreferredSize(new Dimension(320, -1));
        rightSideView.setBackground(BoundariesPanelImpl.BETWEEN_CARD_COLOR);
        limitProperties = this.wrapWithCardBorder(limitProperties, this.text.limitProperties());
        rightSideView.add((Component)limitProperties, "Center");
        offsetProperties = this.wrapWithCardBorder(offsetProperties, this.text.toolProperties());
        rightSideView.add((Component)offsetProperties, "South");
        ViewBehaviorWrapper wrapper = new ViewBehaviorWrapper(this.featuresLookup);
        RobotCanvas3D robotCanvas3D = this.view3DPanel.getRobotCanvas3D();
        robotCanvas3D.addJ3DComponent((J3DComponent)new ZoomRenderer(robotCanvas3D.getComponent(), (ViewBehaviorHolder)wrapper));
        robotCanvas3D.alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)wrapper));
        this.view3DPanel.setBorder((Border)new CardBorder(this.text.Robot()));
        this.add((Component)rightSideView, "East");
        this.add((Component)((Object)this.view3DPanel), "Center");
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this.view3DPanel), "gui:installation_safety_boundaries_3d_view");
        this.helpIdAssigner.assignHelpId((JComponent)limitProperties, "gui:installation_safety_tool_limit_properties");
        this.helpIdAssigner.assignHelpId((JComponent)offsetProperties, "gui:installation_safety_tool_properties");
    }

    private JPanel wrapWithCardBorder(JPanel limitProperties, String title) {
        JPanel limitPropertiesPanel = new JPanel(new BorderLayout());
        limitPropertiesPanel.setBorder((Border)new CardBorder(title));
        limitPropertiesPanel.add((Component)limitProperties, "Center");
        return limitPropertiesPanel;
    }

    @Override
    public void setAvailableFeatures(Iterable<SpatialFeature> features) {
        this.toolFeatures.setFeatures(features);
    }

    @Override
    public void setLimitProperties(GeomFeature feature, SafetyLimitMode safetyLimitMode, double deviationValue) {
        this.toolFeatures.setSelection(feature);
        this.toolSafetyMode.setSafetyMode(safetyLimitMode);
        this.deviation.setValue(deviationValue);
    }

    @Override
    public void setSelectedFeatureState(ElementDefinitionState definitionState) {
        this.toolFeatures.setSelectedFeatureState(definitionState);
    }

    @Override
    public void setTCPList(Iterable<TCP> tcps) {
        this.tcpSelection.setTCPs(tcps);
    }

    @Override
    public void selectTCP(SelectTCP.Definition definition) {
        this.tcpSelection.setSelection(definition);
    }

    @Override
    public void selectTCP(TCP tcp) {
        this.tcpSelection.setSelection(tcp);
    }

    @Override
    public void setCoordinates(CoordinateValues<SphericalAngleCoordinates> values) {
        this.orientationOffsetCoordinates.setCoordinate(values);
    }

    @Override
    public void setEnabledSelectFeature(boolean enabled) {
        this.toolFeatures.setEnabledSelection(enabled);
    }

    @Override
    public void setEnabledSynchronizeFeature(boolean enabled) {
        this.toolFeatures.setEnabledSynchronization(enabled);
    }

    @Override
    public void setEnabledSelectSafetyMode(boolean enabled) {
        this.toolSafetyMode.setEnabled(enabled);
    }

    @Override
    public void setEnabledChangeDeviation(boolean enabled) {
        this.deviation.setEnabled(enabled);
    }

    @Override
    public void setEnabledSelectTCP(boolean enabled) {
        this.tcpSelection.setEnabled(enabled);
    }

    @Override
    public void setTCPSynchronizationPossible(boolean enabled) {
        this.tcpSelection.setSynchronizationPossible(enabled);
    }

    @Override
    public void setEnabledSetCoordinates(boolean enabled) {
        this.orientationOffsetCoordinates.setEnabled(enabled);
    }
}

