/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapcontribution;

import com.ur.lang.Defense;
import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.urcapcontribution.SafetyConfigurationState;
import com.ur.safety.urcapcontribution.SafetyNodeContributionHolder;
import com.ur.safety.urcapcontribution.URCapSafetyChangeListener;
import com.ur.safety.urcapcontribution.URCapSafetyLock;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyChecksum;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyConfigurationInformer;
import com.ur.urcap.api.contribution.installation.swing.safety.AppliedSafetyHandler;
import com.ur.urcap.api.contribution.installation.swing.safety.SafetyNodeContribution;
import javax.inject.Provider;

public class SafetyContribution
extends SafetyNodeContributionHolder {
    private final URCapSafetyLock safetyLock;
    private final SafetySettingsCaretaker safetySettingsCaretaker;
    private final SafetyEquipmentContributionService manager;
    private URCapSafetyChangeListener safetyChangeListener;
    private SafetyConfigurationState safetyConfigurationState;
    private SafetyConfigurationState.Listener safetyStateListener;
    private AppliedSafetyHandler applySafetyHandler;
    private URCapErrorPropagator urCapErrorPropagator = new NullURCapErrorPropagator();

    public SafetyContribution(Provider<SafetyNodeContribution> nodeContributionProvider, URCapSafetyLock safetyLock, SafetySettingsCaretaker safetySettingsCaretaker, SafetyEquipmentContributionService manager) {
        super(nodeContributionProvider);
        this.safetyLock = safetyLock;
        this.safetySettingsCaretaker = safetySettingsCaretaker;
        this.manager = manager;
        this.safetyConfigurationState = new SafetyConfigurationState(this.safetyStateListener);
        this.safetyConfigurationState.invalidate();
    }

    public SafetyConfigurationState getSafetyConfigurationState() {
        return this.safetyConfigurationState;
    }

    public void setSafetyStateListener(SafetyConfigurationState.Listener listener) {
        this.safetyStateListener = listener;
    }

    public boolean canLockSafety() {
        if (this.safetyConfigurationState.getState() == SafetyConfigurationState.State.UNCHANGED) {
            return true;
        }
        if (this.safetyConfigurationState.getState() == SafetyConfigurationState.State.COMPLETED) {
            this.applyOrRevertSafety();
            return true;
        }
        return this.revertSafety(SafetySettingsCaretaker.AskUserToRevert.OR_CANCEL);
    }

    public void lockView() {
        this.handleUnappliedChanges();
        this.getContribution().lockView();
        this.ensureSafetyHasBeenLocked();
        this.safetyConfigurationState.invalidate();
    }

    private void handleUnappliedChanges() {
        SafetyConfigurationState.State state = this.safetyConfigurationState == null ? SafetyConfigurationState.State.UNCHANGED : this.safetyConfigurationState.getState();
        state.apply(this);
    }

    private void ensureSafetyHasBeenLocked() {
        if (this.isUnlocked()) {
            this.safetyLock.lockSafety();
        }
    }

    public void unlockView() {
        this.safetyConfigurationState = new SafetyConfigurationState(this.safetyStateListener);
        this.getContribution().unlockView((SafetyConfigurationInformer)this.safetyConfigurationState);
        this.applySafetyHandler = this.getAppliedSafetyHandler(this.urCapErrorPropagator);
        if (this.applySafetyHandler == null) {
            this.lockView();
        }
    }

    public SafetyLock getLock() {
        return this.safetyLock;
    }

    public boolean isUnlocked() {
        return !this.safetyLock.isLocked();
    }

    public boolean revertSafety(SafetySettingsCaretaker.AskUserToRevert askUserToRevert) {
        boolean result = this.safetySettingsCaretaker.revertChanges(askUserToRevert);
        if (result) {
            this.applySafetyHandler.onReverted();
            this.safetyConfigurationState.markAsUnchanged();
        }
        return result;
    }

    public void applyOrRevertSafety() {
        Defense.isCondition((this.safetyConfigurationState.getState() == SafetyConfigurationState.State.COMPLETED ? 1 : 0) != 0, (String)"SafetyConfigurationState must be COMPLETED");
        this.setSafetyChecksum(this.safetyConfigurationState.getChecksum());
        this.applySafetySettingsOrRevert();
        this.safetyConfigurationState.markAsUnchanged();
    }

    public boolean applyOrCancelSafety() {
        if (!this.isAppliable()) {
            return false;
        }
        if (this.hasAppliableChanges()) {
            this.setSafetyChecksum(this.safetyConfigurationState.getChecksum());
            return this.applySafetySettings();
        }
        return this.reapplySafetySettings();
    }

    private void setSafetyChecksum(SafetyChecksum safetyChecksum) {
        Defense.notNull((Object)safetyChecksum, (String)"SafetyChecksum cannot be null");
        this.updateChecksumInSafetyContribution(safetyChecksum);
    }

    private boolean isAppliable() {
        SafetyConfigurationState.State state = this.safetyConfigurationState.getState();
        return state == SafetyConfigurationState.State.COMPLETED || state == SafetyConfigurationState.State.UNCHANGED;
    }

    private boolean hasAppliableChanges() {
        return this.safetyConfigurationState.getState() == SafetyConfigurationState.State.COMPLETED;
    }

    private void applySafetySettingsOrRevert() {
        this.registerSafetyChangeListener();
        boolean isApplied = this.reapplySafetySettingsOrRevert();
        if (!isApplied) {
            this.safetySettingsCaretaker.revertToControllerState();
            this.applySafetyHandler.onReverted();
        }
    }

    private boolean applySafetySettings() {
        boolean isApplied = this.applySafetyAndRegisterListener();
        if (isApplied) {
            this.safetyConfigurationState.markAsUnchanged();
        }
        return isApplied;
    }

    private boolean applySafetyAndRegisterListener() {
        this.registerSafetyChangeListener();
        return this.reapplySafetySettings();
    }

    public void registerSafetyChangeListener() {
        this.unregisterSafetyChangeListener();
        this.safetyChangeListener = new URCapSafetyChangeListener(this.applySafetyHandler);
    }

    public void unregisterSafetyChangeListener() {
        if (this.safetyChangeListener != null) {
            this.safetyChangeListener.unregister();
        }
        this.safetyChangeListener = null;
    }

    private boolean reapplySafetySettings() {
        return this.safetySettingsCaretaker.applyChangesToController(SafetySettingsCaretaker.AskUserToApply.OR_CANCEL, true);
    }

    private boolean reapplySafetySettingsOrRevert() {
        return this.safetySettingsCaretaker.applyChangesToController(SafetySettingsCaretaker.AskUserToApply.OR_REVERT, true);
    }

    private void updateChecksumInSafetyContribution(SafetyChecksum safetyChecksum) {
        SafetyEquipment device = this.manager.getDevices().iterator().next();
        this.manager.updateChecksum(device, safetyChecksum);
    }

    public void bindErrorHandling(URCapErrorPropagator urCapErrorPropagator) {
        this.urCapErrorPropagator = urCapErrorPropagator;
    }

    private static class NullURCapErrorPropagator
    implements URCapErrorPropagator {
        private NullURCapErrorPropagator() {
        }

        @Override
        public void informAndDisableURCap(String fullyQualifiedClassName, Throwable e, String method) {
        }

        @Override
        public void inform(String fullyQualifiedClassName, Throwable e, String method) {
        }
    }

    public static interface URCapErrorPropagator {
        public void informAndDisableURCap(String var1, Throwable var2, String var3);

        public void inform(String var1, Throwable var2, String var3);
    }
}

