/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapcontribution;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.urcap.api.contribution.installation.swing.safety.AppliedSafetyHandler;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;

public class URCapSafetyChangeListener
extends SafetyChangeListener.Template {
    private static EventManager eventManager;
    private final AppliedSafetyHandler appliedSafetyHandler;
    private final AtomicBoolean unregistered = new AtomicBoolean(false);
    private final Subscription subscription;
    private SafetySetup previousSetup;

    public URCapSafetyChangeListener(AppliedSafetyHandler appliedSafetyHandler) {
        this.appliedSafetyHandler = appliedSafetyHandler;
        this.subscription = eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
    }

    @Inject
    public static void registerEventManager(EventManager eventManager) {
        URCapSafetyChangeListener.eventManager = eventManager;
    }

    @Override
    public void safetyOnControllerUpdated(SafetySetup setup, SafetySetup previousSetup) {
        if (this.unregistered.get()) {
            return;
        }
        this.updatePreviousSetup(previousSetup);
    }

    @Override
    public void safetyRequestedToBeApplied(SafetySetup setup) {
        this.appliedSafetyHandler.onApplying();
    }

    private void updatePreviousSetup(SafetySetup previousSetup) {
        if (this.previousSetup == null) {
            this.previousSetup = previousSetup;
        }
    }

    @Override
    public void safetyReverted(SafetySetup rejectedSafety, SafetySetup setup) {
        if (this.unregister()) {
            return;
        }
        this.invokeOnReverted(rejectedSafety, setup);
    }

    private void invokeOnReverted(SafetySetup rejectedSafety, SafetySetup setup) {
        if (this.hasUnchangedSafetyDeviceChecksum(setup, rejectedSafety)) {
            return;
        }
        this.appliedSafetyHandler.onReverted();
    }

    @Override
    public void safetyOnControllerConfirmed(SafetySetup confirmedSetup) {
        if (this.unregister()) {
            return;
        }
        this.invokeOnConfirmed(confirmedSetup);
    }

    private void invokeOnConfirmed(SafetySetup confirmedSetup) {
        if (this.hasUnchangedSafetyDeviceChecksum(confirmedSetup, this.previousSetup)) {
            return;
        }
        this.appliedSafetyHandler.onConfirmed();
    }

    private boolean hasUnchangedSafetyDeviceChecksum(SafetySetup confirmedSetup, SafetySetup oldSetup) {
        SafetyDeviceConfiguration oldDeviceConfig;
        if (oldSetup == null) {
            return false;
        }
        SafetyDeviceConfiguration confirmedDeviceConfig = (SafetyDeviceConfiguration)confirmedSetup.getComponent(SafetyDeviceConfiguration.class);
        return !URCapSafetyChangeListener.searchForChangedChecksum(confirmedDeviceConfig, oldDeviceConfig = (SafetyDeviceConfiguration)oldSetup.getComponent(SafetyDeviceConfiguration.class));
    }

    private static boolean searchForChangedChecksum(SafetyDeviceConfiguration confirmedDeviceConfig, SafetyDeviceConfiguration oldDeviceConfig) {
        for (SafetyEquipment confirmedDevice : confirmedDeviceConfig.getSafetyDevices()) {
            for (SafetyEquipment oldDevice : oldDeviceConfig.getSafetyDevices()) {
                if (!confirmedDevice.getUuid().equals(oldDevice.getUuid()) || confirmedDevice.getChecksum().equals((Object)oldDevice.getChecksum())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean unregister() {
        if (this.unregistered.getAndSet(true)) {
            return true;
        }
        this.unregistered.set(true);
        this.subscription.dispose();
        return false;
    }
}

