/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapcontribution;

import com.ur.polyscope.safety.SafetySettingsCaretaker;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.safety.SafetyControlsCard;
import com.ur.safety.urcapcontribution.SafetyConfigurationState;
import com.ur.safety.urcapcontribution.SafetyContribution;
import com.ur.swing.ViewContext;
import java.awt.event.ActionEvent;

public class URCapSafetyControlsCard
extends SafetyControlsCard
implements SafetyConfigurationState.Listener {
    private static final String PANEL_NAME = "urcap.SafetyControlsCard";
    private final SafetyContribution safetyContribution;

    public URCapSafetyControlsCard(SafetyContribution safetyContribution, SafetySettingsCaretaker lookupService, Errorable errorable, ViewContext viewContext) {
        super(safetyContribution.getLock(), lookupService, errorable, viewContext);
        this.safetyContribution = safetyContribution;
        this.setName(PANEL_NAME);
        safetyContribution.setSafetyStateListener(this);
    }

    @Override
    protected void updateEnabledStateForApplySettings() {
        this.updateState(this.getCurrentState());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getCurrentState() == SafetyConfigurationState.State.INPROGRESS) {
            return;
        }
        this.safetyContribution.applyOrCancelSafety();
    }

    @Override
    public void updateState(SafetyConfigurationState.State state) {
        this.applySafetySettingsButton.setEnabled(this.isUnlocked() && this.isStateAllowingApply(state));
    }

    private boolean isUnlocked() {
        return this.safetyContribution != null && this.safetyContribution.isUnlocked();
    }

    private boolean isStateAllowingApply(SafetyConfigurationState.State state) {
        return state == SafetyConfigurationState.State.UNCHANGED || state == SafetyConfigurationState.State.COMPLETED;
    }

    private SafetyConfigurationState.State getCurrentState() {
        return this.safetyContribution == null || this.safetyContribution.getSafetyConfigurationState() == null ? SafetyConfigurationState.State.UNCHANGED : this.safetyContribution.getSafetyConfigurationState().getState();
    }
}

