/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.data;

import com.google.common.collect.Sets;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.safety.hardware.HardwarePanelNavigationEvent;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.util.event.EventManager;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MonitorForErrorsOnLoad
implements InstallationListener {
    private final SafetyEquipmentContributionService safetyEquipmentContributionService;
    private final EventManager eventManager;
    private final Set<InstallationListener.EventType> loadEvents;

    @Inject
    public MonitorForErrorsOnLoad(SafetyEquipmentContributionService safetyEquipmentContributionService, EventManager eventManager) {
        this.safetyEquipmentContributionService = safetyEquipmentContributionService;
        this.eventManager = eventManager;
        this.loadEvents = Sets.immutableEnumSet((Enum)InstallationListener.EventType.INSTALLATION_READY, (Enum[])new InstallationListener.EventType[]{InstallationListener.EventType.PRE_LOAD_INSTALLATION, InstallationListener.EventType.CHANGED});
        eventManager.addStrongListener(InstallationListener.class, (Object)this);
    }

    public void onInstallationEvent(InstallationListener.Event event) {
        if (!this.safetyEquipmentContributionService.hasSafetyDevicesErrors() || !this.loadEvents.contains(event.getType())) {
            return;
        }
        this.eventManager.fireEvent(HardwarePanelNavigationEvent.class, HardwarePanelNavigationEvent::navigateToHardwarePanel);
    }
}

