/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.data;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.controllerinterface.SafetyConfigurationParser;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import java.io.DataInput;
import java.io.IOException;
import java.util.UUID;

public class SafetyDeviceConfigurationParser
extends SafetyConfigurationParser.ActiveParserTemplate<SafetyDeviceConfiguration> {
    public static final long BYTE_MASK = 255L;
    private SafetyDeviceConfiguration result;

    @Override
    public Class<SafetyDeviceConfiguration> getType() {
        return SafetyDeviceConfiguration.class;
    }

    @Override
    public SafetyDeviceConfiguration getResult() {
        return this.result;
    }

    @Override
    public void parse(DataInput input, ChecksumVersion version) throws IOException {
        if (!version.atLeast(ChecksumVersion.VERSION_5_9)) {
            return;
        }
        this.result = new SafetyDeviceConfiguration();
        int numberOfSafetyDevices = input.readUnsignedByte();
        int i = 0;
        while (i < numberOfSafetyDevices) {
            this.parseSafetyDevice(this.result, input);
            ++i;
        }
    }

    private void parseSafetyDevice(SafetyDeviceConfiguration result, DataInput input) throws IOException {
        int index = input.readUnsignedByte();
        UUID uuid = new UUID(input.readLong(), input.readLong());
        long checksum = this.toUnsignedInt(this.getChecksumBytes(input));
        result.addSafetyDeviceFromController(uuid, checksum, index);
    }

    private byte[] getChecksumBytes(DataInput input) throws IOException {
        byte[] checksumBytes = new byte[4];
        input.readFully(checksumBytes);
        return checksumBytes;
    }

    private long toUnsignedInt(byte[] bytes) {
        return ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }
}

