/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.data;

import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.urcapequipment.domain.EquipmentRegistrar;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import java.util.stream.IntStream;

public class SafetyDeviceContribution
implements SafetySetupContribution<SafetyDeviceConfiguration> {
    public static final String SAFETY_DEVICES_SECTION_NAME = "SafetyDevices";
    public static final String SAFETY_DEVICES_NUMBER_OF_ENABLED_DEVICES = "numberOfEnabledDevices";
    public static final String SAFETY_DEVICES_ITEM_HEADER = "SafetyDevice";
    public static final String SAFETY_DEVICES_NAME = "safetyDeviceName";
    public static final String SAFETY_DEVICES_INDEX = "safetyDeviceIndex";
    public static final String SAFETY_DEVICES_UUID = "safetyDeviceUUID";
    public static final String SAFETY_DEVICES_CHECKSUM = "safetyDeviceChecksum";
    private static final String ID = "Id";
    private static final String OWNER_ID = "OwnerId";
    private static final String OWNER_DISPLAY_NAME = "OwnerDisplayName";

    public Class<SafetyDeviceConfiguration> getComponentType() {
        return SafetyDeviceConfiguration.class;
    }

    public SafetyDeviceConfiguration createDefaultComponent() {
        return new SafetyDeviceConfiguration();
    }

    public SafetyDeviceConfiguration readFromOptions(ChecksumVersion checksumVersion, Options options) {
        OptionsSection section = options.getSection(SAFETY_DEVICES_SECTION_NAME);
        Integer numberOfSafetyDevices = section.getInteger(SAFETY_DEVICES_NUMBER_OF_ENABLED_DEVICES, Integer.valueOf(0));
        SafetyDeviceConfiguration result = new SafetyDeviceConfiguration();
        IntStream.range(0, numberOfSafetyDevices).forEachOrdered(i -> this.getSafetyDeviceFromOptions(result, options, i));
        return result;
    }

    private void getSafetyDeviceFromOptions(SafetyDeviceConfiguration configuration, Options options, int index) {
        OptionsSection section = options.getSection(SAFETY_DEVICES_ITEM_HEADER + index);
        Integer deviceIndex = section.getInteger(SAFETY_DEVICES_INDEX, Integer.valueOf(0));
        String name = section.getString(SAFETY_DEVICES_NAME);
        String uuid = section.getString(SAFETY_DEVICES_UUID);
        long checksum = section.getLong(SAFETY_DEVICES_CHECKSUM, Long.valueOf(0L));
        EquipmentRegistrar registrar = this.getEquipmentRegistrar(section);
        configuration.addSafetyFromConfiguration(name, uuid, checksum, deviceIndex, registrar);
    }

    private EquipmentRegistrar getEquipmentRegistrar(OptionsSection safetyDeviceSection) {
        String id = safetyDeviceSection.getString(ID);
        String ownerId = safetyDeviceSection.getString(OWNER_ID);
        String ownerDisplayName = safetyDeviceSection.getString(OWNER_DISPLAY_NAME);
        return new EquipmentRegistrar(ownerId, id, ownerDisplayName);
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, SafetyDeviceConfiguration safetyDeviceConfiguration) {
        OptionsSection section = options.getSection(SAFETY_DEVICES_SECTION_NAME);
        section.setInteger(SAFETY_DEVICES_NUMBER_OF_ENABLED_DEVICES, Integer.valueOf(safetyDeviceConfiguration.getSafetyDevices().size()));
        safetyDeviceConfiguration.getSafetyDevices().forEach(it -> {
            OptionsSection deviceSection = options.getSection(SAFETY_DEVICES_ITEM_HEADER + it.getIndex());
            deviceSection.setInteger(SAFETY_DEVICES_INDEX, Integer.valueOf(it.getIndex()));
            deviceSection.setString(SAFETY_DEVICES_NAME, it.getName());
            deviceSection.setString(SAFETY_DEVICES_UUID, it.getUuidAsString());
            deviceSection.setLong(SAFETY_DEVICES_CHECKSUM, Long.valueOf(it.getChecksum().asLong()));
            EquipmentRegistrar registrar = safetyDeviceConfiguration.getEquipmentRegistrar(it.getUuid());
            deviceSection.setString(ID, registrar.getId());
            deviceSection.setString(OWNER_ID, registrar.getOwnerId());
            deviceSection.setString(OWNER_DISPLAY_NAME, registrar.getOwnerDisplayName());
        });
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, SafetyDeviceConfiguration safetyDeviceConfiguration) {
        OptionsSection section = options.getSection(SAFETY_DEVICES_SECTION_NAME);
        section.setInteger(SAFETY_DEVICES_NUMBER_OF_ENABLED_DEVICES, Integer.valueOf(safetyDeviceConfiguration.getSafetyDevices().size()));
        safetyDeviceConfiguration.getSafetyDevices().forEach(it -> {
            OptionsSection deviceSection = options.getSection(SAFETY_DEVICES_ITEM_HEADER + it.getIndex());
            deviceSection.setInteger(SAFETY_DEVICES_INDEX, Integer.valueOf(it.getIndex()));
            deviceSection.setString(SAFETY_DEVICES_UUID, it.getUuidAsString());
            deviceSection.setLong(SAFETY_DEVICES_CHECKSUM, Long.valueOf(it.getChecksum().asLong()));
        });
    }

    public boolean isSupported(ChecksumVersion checksumVersion) {
        return checksumVersion.atLeast(ChecksumVersion.VERSION_5_9);
    }
}

