/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.urcap.api.contribution.installation.configuration.safety.ReadOnceSeed;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public class EquipmentID {
    private final UUID id;

    EquipmentID(UUID uuid) {
        if (Objects.isNull(uuid)) {
            throw new InvalidDeviceSeed("UUID can not be null");
        }
        this.id = uuid;
    }

    public EquipmentID(ReadOnceSeed seed) {
        if (Objects.isNull(seed)) {
            throw new InvalidDeviceSeed("seed can not be null");
        }
        this.id = EquipmentID.generateUuidFromSeed(seed.value());
    }

    public UUID asUUID() {
        return this.id;
    }

    private static UUID generateUuidFromSeed(String seed) {
        String hash = DigestUtils.md5Hex((String)seed);
        return UUID.fromString(EquipmentID.addDashedToHash(hash));
    }

    private static String addDashedToHash(String hash) {
        StringBuilder stringBuilder = new StringBuilder(hash);
        stringBuilder.insert(20, "-").insert(16, "-").insert(12, "-").insert(8, "-");
        return stringBuilder.toString();
    }

    public String toString() {
        return "DeviceID{id=" + this.id.toString().split("-")[0] + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EquipmentID equipmentID = (EquipmentID)o;
        return Objects.equals(this.id, equipmentID.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    static class InvalidDeviceSeed
    extends IllegalArgumentException {
        public InvalidDeviceSeed(String message) {
            super(message);
        }
    }
}

