/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.lang.Defense;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import java.util.Objects;
import java.util.UUID;

public class EquipmentRegistrar
implements ContributorInfo {
    private final String ownerId;
    private final String id;
    private final String vendorAndURCap;

    public EquipmentRegistrar(String ownerId, String id, String vendorAndURCap) {
        Defense.notNullOrEmpty((String)ownerId, (String)"ownerId cannot be null");
        Defense.notNullOrEmpty((String)id, (String)"id cannot be null");
        Defense.notNullOrEmpty((String)vendorAndURCap, (String)"vendorAndURCap cannot be null");
        this.ownerId = ownerId;
        this.id = id;
        this.vendorAndURCap = vendorAndURCap;
    }

    public static EquipmentRegistrar generate(UUID uuid, URCapInformation activeURCapInformation) {
        Defense.notNull((Object)uuid, (String)"UUID cannot be null");
        Defense.notNull((Object)activeURCapInformation, (String)"activeURCapInformation cannot be null");
        return new EquipmentRegistrar(activeURCapInformation.getSymbolicName(), uuid.toString(), String.valueOf(activeURCapInformation.getName()) + " - " + activeURCapInformation.getVendor());
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getId() {
        return this.id;
    }

    public String getOwnerDisplayName() {
        return this.vendorAndURCap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EquipmentRegistrar that = (EquipmentRegistrar)o;
        return Objects.equals(this.ownerId, that.ownerId);
    }

    public int hashCode() {
        return Objects.hash(this.ownerId, this.id);
    }
}

