/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.lang.EndianConverter;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;

public class SafetyDeviceChecksumContribution_5_9
implements SafetyChecksumGenerator_1_0.ChecksumGeneratorContribution<SafetyDeviceConfiguration> {
    private static final int SAFETY_DEVICE_COUNT_BYTE_SIZE = 1;
    private static final int SAFETY_DEVICE_INDEX_BYTE_SIZE = 1;
    private static final int SAFETY_DEVICE_UUID_BYTE_SIZE = 16;
    private static final int SAFETY_DEVICE_HASH_BYTE_SIZE = 4;
    private static final int SAFETY_DEVICE_BYTE_SIZE = 21;
    private SafetySetup safetySetup = null;

    @Override
    public Class<SafetyDeviceConfiguration> getComponentType() {
        return SafetyDeviceConfiguration.class;
    }

    @Override
    public void setSafetySetup(SafetySetup safetySetup) {
        this.safetySetup = safetySetup;
    }

    @Override
    public int getByteCount() {
        SafetyDeviceConfiguration safetyComponent = (SafetyDeviceConfiguration)this.safetySetup.getComponent(this.getComponentType());
        int safetyDevices = Objects.nonNull(safetyComponent) ? safetyComponent.getSafetyDevices().size() : 0;
        return 1 + 21 * safetyDevices;
    }

    @Override
    public void addBytes(EndianConverter converter, ByteBuffer buffer, SafetyDeviceConfiguration component) {
        if (component == null) {
            return;
        }
        buffer.put((byte)component.getSafetyDevices().size());
        component.getSafetyDevices().forEach(it -> this.addSafetEquipmentBytes(buffer, (SafetyEquipment)it));
    }

    private void addSafetEquipmentBytes(ByteBuffer buffer, SafetyEquipment safetyEquipment) {
        buffer.put((byte)safetyEquipment.getIndex());
        UUID uuid = safetyEquipment.getUuid();
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        byte[] checksumBytes = this.longToBytes(safetyEquipment.getChecksum().asLong());
        buffer.put(checksumBytes);
    }

    private byte[] longToBytes(long data) {
        return new byte[]{(byte)(data >> 0 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL)};
    }
}

