/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.EqualsUtil;
import com.ur.lang.HashCodeBuilder;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.urcapequipment.domain.EquipmentID;
import com.ur.safety.urcapequipment.domain.EquipmentName;
import com.ur.safety.urcapequipment.domain.EquipmentRegistrar;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyChecksum;
import com.ur.util.event.EventNotificationService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class SafetyDeviceConfiguration
implements SafetySetupComponent {
    public static final String ENABLED_DEVICES = "enabledDevices";
    public static final String SAFETY_DEVICE_CHECKSUM = "SAFETY_DEVICE_CHECKSUM";
    private static final String PLACEHOLDER = "PLACEHOLDER";
    private static final EquipmentName PLACEHOLDER_NAME = new EquipmentName("PLACEHOLDER");
    private static final EquipmentRegistrar PLACEHOLDER_REGISTRAR = new EquipmentRegistrar("PLACEHOLDER", "PLACEHOLDER", "PLACEHOLDER");
    private final PropertyChangeSupport changeSupport;
    private final Map<UUID, SafetyEquipment> safetyDevices = new HashMap<UUID, SafetyEquipment>();
    private final Map<UUID, EquipmentRegistrar> possiblyUnregisteredEquipment = new HashMap<UUID, EquipmentRegistrar>();

    public SafetyDeviceConfiguration() {
        this.changeSupport = new URPropertyChangeSupport((Object)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean completelyEquals(Object other) {
        return this.equals(other);
    }

    public boolean isReducedModeDefined() {
        return false;
    }

    public void addSafetyDeviceFromController(UUID uuid, long checksum, int index) {
        this.addSafetyDevice(new SafetyEquipment(PLACEHOLDER_NAME, new EquipmentID(uuid), new SafetyChecksum(checksum), index, PLACEHOLDER_REGISTRAR.getOwnerId()), PLACEHOLDER_REGISTRAR);
    }

    public void addSafetyFromConfiguration(String name, String uuid, long checksum, int deviceIndex, EquipmentRegistrar registrar) {
        EquipmentName equipmentName = new EquipmentName(name);
        EquipmentID equipmentID = new EquipmentID(UUID.fromString(uuid));
        SafetyChecksum safetyChecksum = new SafetyChecksum(checksum);
        this.addSafetyDevice(new SafetyEquipment(equipmentName, equipmentID, safetyChecksum, deviceIndex, registrar.getOwnerId()), registrar);
    }

    public void addSafetyDevice(SafetyEquipment safetyEquipment, EquipmentRegistrar registrar) {
        safetyEquipment.enable();
        ArrayList<SafetyEquipment> oldValue = new ArrayList<SafetyEquipment>(this.safetyDevices.values());
        this.safetyDevices.put(safetyEquipment.getUuid(), safetyEquipment);
        this.possiblyUnregisteredEquipment.put(safetyEquipment.getUuid(), registrar);
        this.changeSupport.firePropertyChange(ENABLED_DEVICES, oldValue, new ArrayList<SafetyEquipment>(this.safetyDevices.values()));
    }

    public void removeSafetyDevice(SafetyEquipment safetyEquipment) {
        safetyEquipment.disable();
        ArrayList<SafetyEquipment> oldValue = new ArrayList<SafetyEquipment>(this.safetyDevices.values());
        this.safetyDevices.remove(safetyEquipment.getUuid());
        this.changeSupport.firePropertyChange(ENABLED_DEVICES, oldValue, new ArrayList<SafetyEquipment>(this.safetyDevices.values()));
    }

    public EquipmentRegistrar getEquipmentRegistrar(UUID uuid) {
        return this.possiblyUnregisteredEquipment.get(uuid);
    }

    public List<SafetyEquipment> getSafetyDevices() {
        return new ArrayList<SafetyEquipment>(this.safetyDevices.values());
    }

    public void updateChecksum(SafetyChecksum safetyChecksum) {
        Optional<SafetyEquipment> optionalSafetyDevice = this.safetyDevices.values().stream().findFirst();
        optionalSafetyDevice.ifPresent(safetyDevice -> this.verifyAndUpdateChecksum(safetyChecksum, (SafetyEquipment)safetyDevice));
    }

    private void verifyAndUpdateChecksum(SafetyChecksum safetyChecksum, SafetyEquipment safetyEquipment) {
        SafetyChecksum oldChecksum = safetyEquipment.getChecksum();
        if (!EqualsUtil.equals((Object)oldChecksum, (Object)safetyChecksum)) {
            safetyEquipment.setSafetyChecksum(safetyChecksum);
            this.sendEventsToMarkSafetyAsUnverifiedAndInstallationAsModified(oldChecksum, safetyChecksum);
        }
    }

    private void sendEventsToMarkSafetyAsUnverifiedAndInstallationAsModified(SafetyChecksum oldChecksum, SafetyChecksum newChecksum) {
        this.changeSupport.firePropertyChange(SAFETY_DEVICE_CHECKSUM, oldChecksum, newChecksum);
        EventNotificationService.notify(InstallationStateListener.class, InstallationStateListener::installationModified);
    }

    public boolean containsSafetyDevice(SafetyEquipment safetyEquipment) {
        return this.safetyDevices.containsKey(safetyEquipment.getUuid());
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).append(this.safetyDevices.size()).append((Object)this.getSafetyDevicesString()).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SafetyDeviceConfiguration that = (SafetyDeviceConfiguration)o;
        return Objects.equals(this.safetyDevices, that.safetyDevices);
    }

    public String toString() {
        return "SafetyDeviceConfiguration [" + this.safetyDevices.size() + ", " + this.getSafetyDevicesString() + "]";
    }

    private String getSafetyDevicesString() {
        return this.safetyDevices.values().stream().sorted(Comparator.comparing(SafetyEquipment::getIndex)).map(SafetyEquipment::toString).collect(Collectors.joining());
    }
}

