/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.lang.Defense;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.urcapequipment.domain.EquipmentID;
import com.ur.safety.urcapequipment.domain.EquipmentName;
import com.ur.safety.urcapequipment.domain.RegisteredSafetyEquipment;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyChecksum;
import java.util.Objects;
import java.util.UUID;

public class SafetyEquipment {
    private final EquipmentName name;
    private final EquipmentID equipmentID;
    private final int index;
    private SafetyChecksum checksum;
    private boolean enabled = false;
    private final String ownerId;

    public SafetyEquipment(EquipmentName name, EquipmentID equipmentID, SafetyChecksum checksum, int index, String ownerId) {
        Defense.notNull((Object)name, (String)"name cannot be null");
        Defense.notNull((Object)equipmentID, (String)"uuid cannot be null");
        this.equipmentID = equipmentID;
        this.name = name;
        this.checksum = checksum;
        this.index = index;
        this.ownerId = ownerId;
    }

    public static SafetyEquipment createDisabledConfiguration(RegisteredSafetyEquipment device, int index) {
        return new SafetyEquipment(device.name(), device.id(), device.initialChecksum(), index, device.getOwnerId());
    }

    public String getName() {
        return this.name.asString();
    }

    public UUID getUuid() {
        return this.equipmentID.asUUID();
    }

    public String getUuidAsString() {
        return this.getUuid().toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public SafetyChecksum getChecksum() {
        return this.checksum;
    }

    public void setSafetyChecksum(SafetyChecksum configurationHash) {
        this.checksum = configurationHash;
    }

    public String getChecksumAsString() {
        return String.valueOf(this.checksum.asLong());
    }

    public int getIndex() {
        return this.index;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public boolean isSameRegistration(SafetyEquipment safetyEquipment) {
        return Objects.equals(safetyEquipment.getUuid(), this.getUuid()) && Objects.equals(safetyEquipment.getOwnerId(), this.getOwnerId());
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public int hashCode() {
        return new HashCodeBuilder(URMath.HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }

    public String toString() {
        return this.name + " {index=" + this.index + ", checksum=" + this.checksum.asLong() + ", " + this.equipmentID + ", " + this.enabled + ", " + this.ownerId + "}";
    }
}

