/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.google.common.collect.ImmutableList;
import com.ur.lang.Defense;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.safety.urcapequipment.domain.EquipmentRegistrar;
import com.ur.safety.urcapequipment.domain.RegisteredSafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentWrapper;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyChecksum;
import com.ur.urcap.api.domain.device.safety.OnlyOneRegistrationSupported;
import com.ur.urcap.api.domain.device.safety.SafetyEquipmentAlreadyRegistered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

class SafetyEquipmentCollection {
    private final Map<UUID, RegisteredSafetyEquipment> registeredSafetyDevices = new HashMap<UUID, RegisteredSafetyEquipment>();
    private Collection<SafetyEquipmentWrapper> deviceCollection = new ArrayList<SafetyEquipmentWrapper>();
    private SafetyDeviceConfiguration activeConfiguration;

    SafetyEquipmentCollection() {
    }

    void registerDevice(RegisteredSafetyEquipment registeredDevice) {
        if (this.registeredSafetyDevices.containsKey(registeredDevice.id().asUUID())) {
            throw new SafetyEquipmentAlreadyRegistered("Another safety device is already registered");
        }
        if (this.hasMultipleRegistrationsForURCap(registeredDevice.contributorInfo())) {
            String displayName = registeredDevice.contributorInfo().getOwnerDisplayName();
            throw new OnlyOneRegistrationSupported("The URCap " + displayName + " has attempted to register " + "multiple devices. Only one registration is supported");
        }
        this.registeredSafetyDevices.put(registeredDevice.id().asUUID(), registeredDevice);
    }

    private boolean hasMultipleRegistrationsForURCap(ContributorInfo contributorInfo) {
        return this.registeredSafetyDevices.values().stream().anyMatch(device -> device.contributorInfo().equals(contributorInfo));
    }

    void setActiveConfiguration(SafetyDeviceConfiguration activeConfiguration) {
        Defense.notNull((Object)activeConfiguration, (String)"Safety Device configuration cannot be null");
        this.activeConfiguration = activeConfiguration;
        this.resetWithRegisteredDevices();
        activeConfiguration.getSafetyDevices().forEach(this::addUnregisteredDevice);
        this.enableSafetyDevices(activeConfiguration.getSafetyDevices());
    }

    private void resetWithRegisteredDevices() {
        this.deviceCollection = new ArrayList<SafetyEquipmentWrapper>();
        this.registeredSafetyDevices.values().forEach(x -> {
            SafetyEquipment device = SafetyEquipment.createDisabledConfiguration(x, this.getDevicesCount());
            this.deviceCollection.add(new SafetyEquipmentWrapper(device, true));
        });
    }

    private void addUnregisteredDevice(SafetyEquipment safetyEquipment) {
        Optional<SafetyEquipmentWrapper> wrapperById = this.getWrapperByIdAndOwner(safetyEquipment.getUuid(), safetyEquipment.getOwnerId());
        wrapperById.ifPresent(safetyEquipmentWrapper -> {
            boolean bl = this.deviceCollection.remove(safetyEquipmentWrapper);
        });
        this.deviceCollection.add(new SafetyEquipmentWrapper(safetyEquipment, wrapperById.isPresent()));
    }

    private void enableSafetyDevices(Collection<SafetyEquipment> safetyEquipmentList) {
        safetyEquipmentList.forEach(it -> this.getByIdAndOwner(it.getUuid(), it.getOwnerId()).ifPresent(SafetyEquipment::enable));
    }

    Optional<SafetyEquipment> getByIdAndOwner(UUID uuid, String ownerId) {
        return this.getWrapperByIdAndOwner(uuid, ownerId).map(SafetyEquipmentWrapper::getSafetyDevice);
    }

    private Optional<SafetyEquipmentWrapper> getWrapperByIdAndOwner(UUID uuid, String ownerId) {
        return this.deviceCollection.stream().filter(it -> it.isSameSafetyDevice(uuid, ownerId)).findFirst();
    }

    Collection<SafetyEquipment> get() {
        return (Collection)this.deviceCollection.stream().map(SafetyEquipmentWrapper::getSafetyDevice).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    int getDevicesCount() {
        return (int)this.deviceCollection.stream().filter(SafetyEquipmentWrapper::isRegistered).count();
    }

    boolean hasUnregisteredDevices() {
        return this.deviceCollection.stream().filter(it -> it.getSafetyDevice().isEnabled()).anyMatch(it -> !it.isRegistered());
    }

    List<SafetyEquipment> getUnregisteredDevices() {
        return this.deviceCollection.stream().filter(it -> !it.isRegistered()).map(SafetyEquipmentWrapper::getSafetyDevice).collect(Collectors.toList());
    }

    public void enableDevice(SafetyEquipment safetyEquipment) {
        if (!this.getWrapperByIdAndOwner(safetyEquipment.getUuid(), safetyEquipment.getOwnerId()).isPresent()) {
            return;
        }
        EquipmentRegistrar registrar = this.getEquipmentRegistrar(safetyEquipment.getUuid());
        this.activeConfiguration.addSafetyDevice(safetyEquipment, registrar);
    }

    public void disableDevice(SafetyEquipment safetyEquipment) {
        if (!this.activeConfiguration.containsSafetyDevice(safetyEquipment)) {
            return;
        }
        this.activeConfiguration.removeSafetyDevice(safetyEquipment);
    }

    public EquipmentRegistrar getEquipmentRegistrar(UUID uuid) {
        if (this.registeredSafetyDevices.containsKey(uuid)) {
            return this.registeredSafetyDevices.get(uuid).contributorInfo();
        }
        return this.activeConfiguration.getEquipmentRegistrar(uuid);
    }

    public void updateChecksum(SafetyEquipment safetyEquipment, SafetyChecksum safetyChecksum) {
        if (this.activeConfiguration.containsSafetyDevice(safetyEquipment)) {
            this.activeConfiguration.updateChecksum(safetyChecksum);
            return;
        }
        this.getByIdAndOwner(safetyEquipment.getUuid(), safetyEquipment.getOwnerId()).ifPresent(it -> it.setSafetyChecksum(safetyChecksum));
    }
}

