/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.lang.Defense;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.valueobjects.aspects.NotNullArgumentAspect;
import com.ur.polyscope.valueobjects.aspects.StringNotNullOrEmptyAspect;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.valueobjects.validation.NotNull;
import com.ur.polyscope.valueobjects.validation.StringNotNullOrEmpty;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.urcapequipment.domain.EquipmentID;
import com.ur.safety.urcapequipment.domain.EquipmentName;
import com.ur.safety.urcapequipment.domain.EquipmentRegistrar;
import com.ur.safety.urcapequipment.domain.RegisteredSafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentCollection;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService$AjcClosure1;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService$AjcClosure3;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService$AjcClosure5;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentRegistrationFaultService;
import com.ur.urcap.api.contribution.installation.configuration.safety.ReadOnceSeed;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyChecksum;
import com.ur.urcap.api.contribution.installation.configuration.safety.SafetyContributionConfiguration;
import com.ur.urcap.api.domain.device.safety.OnlyOneRegistrationSupported;
import com.ur.urcap.api.domain.device.safety.SafetyEquipmentAlreadyRegistered;
import com.ur.urcap.api.domain.device.safety.SafetyEquipmentRegistration;
import com.ur.util.event.EventManager;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class SafetyEquipmentContributionService
implements SafetyContributionConfiguration {
    private final AtomicInteger registerCounter = new AtomicInteger(0);
    private final SafetyEquipmentCollection safetyEquipmentCollection;
    private final SafetyEquipmentRegistrationFaultService safetyEquipmentRegistrationFaultService;
    private final SafetyTextResource safetyTextResource;
    private URCapInformation activeURCapInformation = new URCapInformation("null", "null", "null", "null");
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public SafetyEquipmentContributionService(EventManager eventManager, SafetyEquipmentRegistrationFaultService safetyEquipmentRegistrationFaultService, SafetyTextResource safetyTextResource) {
        this.safetyEquipmentCollection = new SafetyEquipmentCollection();
        this.safetyEquipmentRegistrationFaultService = safetyEquipmentRegistrationFaultService;
        this.safetyTextResource = safetyTextResource;
        new WatchForSafetyLoaded(eventManager, this);
    }

    public void setActiveURCap(URCapInformation activeURCapInformation) {
        this.activeURCapInformation = activeURCapInformation;
    }

    public SafetyEquipmentRegistration registerSafetyEquipment(@StringNotNullOrEmpty String safetyEquipmentName, @NotNull ReadOnceSeed seed, @NotNull SafetyChecksum factoryDefaultChecksum) {
        Object object;
        String string = safetyEquipmentName;
        ReadOnceSeed readOnceSeed = seed;
        SafetyChecksum safetyChecksum = factoryDefaultChecksum;
        Object[] objectArray = new Object[]{string, readOnceSeed, safetyChecksum};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, readOnceSeed, safetyChecksum, joinPoint};
        SafetyEquipmentContributionService$AjcClosure5 safetyEquipmentContributionService$AjcClosure5 = new SafetyEquipmentContributionService$AjcClosure5(objectArray2);
        try {
            object = NotNullArgumentAspect.aspectOf().aroundAnnotatedMethod(safetyEquipmentContributionService$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            safetyEquipmentContributionService$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            safetyEquipmentContributionService$AjcClosure5.unlink();
            throw throwable;
        }
        return (SafetyEquipmentRegistration)object;
    }

    private RegisteredSafetyEquipment getRegisteredSafetyEquipment(String safetyEquipmentName, ReadOnceSeed seed, SafetyChecksum factoryDefaultChecksum) {
        EquipmentID id = new EquipmentID(seed);
        EquipmentRegistrar contributorInfo = EquipmentRegistrar.generate(id.asUUID(), this.activeURCapInformation);
        EquipmentName equipmentName = new EquipmentName(safetyEquipmentName);
        return new RegisteredSafetyEquipment(equipmentName, id, factoryDefaultChecksum, contributorInfo);
    }

    private boolean isSafetyURCapsLimited() {
        int value = this.registerCounter.getAndIncrement();
        return Settings.isDynamicSafetyLimitsEnabled() && value > 0;
    }

    public int registeredEquipmentCount() {
        return this.registerCounter.intValue();
    }

    public Collection<SafetyEquipment> getDevices() {
        return this.safetyEquipmentCollection.get();
    }

    public SafetyEquipment getSafetyDevice(UUID uuid) {
        return this.safetyEquipmentCollection.get().stream().filter(it -> Objects.equals(it.getUuid(), uuid)).findFirst().orElse(null);
    }

    public void setConfiguration(SafetyDeviceConfiguration configuration) {
        this.safetyEquipmentCollection.setActiveConfiguration(configuration);
    }

    public boolean isDeviceEnabledAndMissingRegistration(SafetyEquipment safetyEquipment) {
        return safetyEquipment.isEnabled() && this.isSafetyDeviceUnregistered(safetyEquipment);
    }

    public boolean hasSafetyDevicesErrors() {
        return this.hasUnregisteredDevices();
    }

    public boolean hasUnregisteredDevices() {
        return this.getDevices().stream().anyMatch(this::isSafetyDeviceUnregistered);
    }

    public boolean isSafetyDeviceUnregistered(SafetyEquipment safetyEquipment) {
        return this.safetyEquipmentCollection.getUnregisteredDevices().stream().anyMatch(it -> it.isEnabled() && it.isSameRegistration(safetyEquipment));
    }

    public void enableDevice(SafetyEquipment safetyEquipment) {
        this.safetyEquipmentCollection.enableDevice(safetyEquipment);
    }

    public void disableDevice(SafetyEquipment safetyEquipment) {
        this.safetyEquipmentCollection.disableDevice(safetyEquipment);
    }

    public EquipmentRegistrar getEquipmentRegistrar(UUID uuid) {
        return this.safetyEquipmentCollection.getEquipmentRegistrar(uuid);
    }

    public void updateChecksum(SafetyEquipment safetyEquipment, SafetyChecksum safetyChecksum) {
        this.safetyEquipmentCollection.updateChecksum(safetyEquipment, safetyChecksum);
    }

    static {
        SafetyEquipmentContributionService.ajc$preClinit();
    }

    static final /* synthetic */ SafetyEquipmentRegistration registerSafetyEquipment_aroundBody0(SafetyEquipmentContributionService ajc$this, String safetyEquipmentName, ReadOnceSeed seed, SafetyChecksum factoryDefaultChecksum, JoinPoint joinPoint) {
        Defense.notNull((Object)ajc$this.activeURCapInformation, (String)"Should specify the URCap that is currently active before registering safety device. Call 'setActiveURCap()' first.");
        if (ajc$this.isSafetyURCapsLimited()) {
            throw new IllegalStateException("Cannot register more than 1 safety device");
        }
        RegisteredSafetyEquipment safetyDevice = ajc$this.getRegisteredSafetyEquipment(safetyEquipmentName, seed, factoryDefaultChecksum);
        try {
            ajc$this.safetyEquipmentCollection.registerDevice(safetyDevice);
        }
        catch (SafetyEquipmentAlreadyRegistered e) {
            ajc$this.safetyEquipmentRegistrationFaultService.handleFailedRegistrations(ajc$this.safetyTextResource.safetyEquipmentDuplicateRegistration(), ajc$this.activeURCapInformation);
            throw e;
        }
        catch (OnlyOneRegistrationSupported e) {
            ajc$this.safetyEquipmentRegistrationFaultService.handleFailedRegistrations(ajc$this.safetyTextResource.safetyEquipmentMultipleRegistrations(), ajc$this.activeURCapInformation);
            throw e;
        }
        return new SafetyEquipmentRegistration(){};
    }

    static final /* synthetic */ SafetyEquipmentRegistration registerSafetyEquipment_aroundBody2(SafetyEquipmentContributionService safetyEquipmentContributionService, String string, ReadOnceSeed readOnceSeed, SafetyChecksum safetyChecksum, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{safetyEquipmentContributionService, string, readOnceSeed, safetyChecksum, joinPoint};
        SafetyEquipmentContributionService$AjcClosure1 safetyEquipmentContributionService$AjcClosure1 = new SafetyEquipmentContributionService$AjcClosure1(objectArray);
        try {
            object = StringNotNullOrEmptyAspect.aspectOf().aroundAnnotatedMethod(safetyEquipmentContributionService$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            safetyEquipmentContributionService$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            safetyEquipmentContributionService$AjcClosure1.unlink();
            throw throwable;
        }
        return (SafetyEquipmentRegistration)object;
    }

    static final /* synthetic */ SafetyEquipmentRegistration registerSafetyEquipment_aroundBody4(SafetyEquipmentContributionService safetyEquipmentContributionService, String string, ReadOnceSeed readOnceSeed, SafetyChecksum safetyChecksum, JoinPoint joinPoint) {
        Object object;
        Object[] objectArray = new Object[]{safetyEquipmentContributionService, string, readOnceSeed, safetyChecksum, joinPoint};
        SafetyEquipmentContributionService$AjcClosure3 safetyEquipmentContributionService$AjcClosure3 = new SafetyEquipmentContributionService$AjcClosure3(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(safetyEquipmentContributionService$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            safetyEquipmentContributionService$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            safetyEquipmentContributionService$AjcClosure3.unlink();
            throw throwable;
        }
        return (SafetyEquipmentRegistration)object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SafetyEquipmentContributionService.java", SafetyEquipmentContributionService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerSafetyEquipment", "com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService", "java.lang.String:com.ur.urcap.api.contribution.installation.configuration.safety.ReadOnceSeed:com.ur.urcap.api.contribution.installation.configuration.safety.SafetyChecksum", "safetyEquipmentName:seed:factoryDefaultChecksum", "", "com.ur.urcap.api.domain.device.safety.SafetyEquipmentRegistration"), 51);
    }

    public static class WatchForSafetyLoaded
    extends SafetyChangeListener.Template {
        private final SafetyEquipmentContributionService service;

        public WatchForSafetyLoaded(EventManager eventManager, SafetyEquipmentContributionService service) {
            this.service = service;
            eventManager.addStrongListener(SafetyChangeListener.class, (Object)this);
        }

        @Override
        public void safetyLoaded(SafetySetup setup) {
            SafetyDeviceConfiguration configuration = (SafetyDeviceConfiguration)setup.getComponent(SafetyDeviceConfiguration.class);
            this.service.setConfiguration(configuration);
        }
    }
}

